
#include "Deciders.h"
#include "MyEntity.h"
#include "../engine/EntityRenderer.h"
#include "../engine/EntityRayPicker.h"
#include "../utils/Random.h"


void CDieDecider::decideFor( CMyEntity& e ) const
{
	e.mFlags |= CMyEntity::F_KILLED;
}

void CJumpDecider::decideFor( CMyEntity& e ) const
{
	// if i'm on the ground - jump from time to time
	if( (e.mFlags & CMyEntity::F_TOUCHES_TERRAIN) && !(rand()&1023) )
		e.mVelocity.z += 10.0f;
	e.mDeciderCounter = 15;
}


void CJumpShotDecider::decideFor( CMyEntity& e ) const
{
	CMyGame& game = CMyGame::getInstance();
	// get my sector
	CMyGame::TGrid::TSector& sector = game.mGrid.getSectorByPosition( e.getPosition().x, e.getPosition().y );
	// i'm initially not shot
	bool shot = false;
	if( sector.mNukeAmount > 0 && (e.mFlags & CMyEntity::F_SMALL) && !(e.mFlags & CMyEntity::F_EVILGOD) ) {
		// if there's "evil god activity" in my sector and i'm a no-god small guy, then i'm shot
		shot = true;
	} else if( sector.mHasRay ) {
		// if my sector has player's shooting ray: test me
		shot = CEntityRayPicker<CMyGame::TGrid>::intersects( e, sector );
	}
	// if i'm shot (but don't allow shooting evil gods)
	if( shot && !(e.mFlags&CMyEntity::F_EVILGOD) ) {
		// throw me up!
		e.mVelocity.z += 15.0f;
		// statistics - small/big?
		if( e.mFlags & CMyEntity::F_SMALL )
			++game.mKilledGoods;
		else if( !(e.mFlags & CMyEntity::F_NOTHING) )
			++game.mKilledBads;
		// shot a good god?
		if( e.mFlags & CMyEntity::F_GOD ) {
			CMyGame::TPool& entities = *game.mPool;
			++game.mKilledGods;
			sector.mNukeAmount = 10; // kill others in my sector for 10 updates
			e.mFlags |= CMyEntity::F_EVILGOD; // become evil god
			e.mVelocity.x += random::randfs(10.0f);
			e.mVelocity.y += random::randfs(10.0f);
			// spawn 50 "nothing" entities in my place (just for fun)
			int n = 50;
			while( entities.hasSpace() && n > 0 ) {
				CMyEntity& ee = entities.add();
				game.getEntities().add( ee ); // add for rendering
				ee.getPosition() = e.getPosition();
				ee.mVelocity = e.mVelocity;
				ee.mVelocity.x += random::randfs( 1.0f );
				ee.mVelocity.y += random::randfs( 1.0f );
				ee.mVelocity.z += random::randfs( 0.5f );
				ee.setColor( 0xFF8080FF ); // blue color
				ee.mDecider = (IDecider*)this;
				ee.mDeciderCounter = 1;
				ee.setSize( 3.5f );
				ee.setPicture( e.getPicture() );
				ee.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_NOTHING;
				--n;
			}
		}
		// make it red color for now, and die after some time, unless he's a god
		e.setColor( 0xFFFF0000 );
		if( !(e.mFlags & CMyEntity::F_GOD) ) {
			e.mDecider = game.mDieDecider;
			e.mDeciderCounter = 60 + (rand()&63);
			e.mVelocity.x = 0.0f; // stop moving
			e.mVelocity.y = 0.0f;
		}
	} else {
		// i'm not shot
		// but if i'm an evil god, increase "evil god activity" here
		if( e.mFlags & CMyEntity::F_EVILGOD )
			++sector.mNukeAmount;
		// default decider - jump ocasionally
		CJumpDecider::decideFor( e );
		// call this decider for me next update
		e.mDeciderCounter = 1;
	}
}
