/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"

class IDecider;

#pragma pack(1)


/**
 *  Your game entity.
 */
class CMyEntity : public CEntity {
public:
	enum {
		F_KEEP_ON_TERRAIN = 1,
		F_GRAVITY = 2,
		F_TOUCHES_TERRAIN = 4,
		F_KILLED = 8,
		F_SMALL = 16, // the small guy. you must kill big ones.
		F_GOD = 32, // this guy is god.
		F_NOTHING = 64, // this guy is spawned, he's just nothing.
		F_EVILGOD = 128 // the evil god
	};
	enum { DEFAULT_DECIDER_COUNTER = 50 };

public:
	void	update();
	
public:
	D3DXVECTOR3		mVelocity;
	short			mFlags;
	short			mDeciderCounter;
	IDecider*		mDecider;
};

#pragma pack()


#endif
