/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "MyEntity.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"
#include "../engine/Grid.h"
#include "Sector.h"
#include <list> // STL list

class CJumpShotDecider; // these you'll write later
class CDieDecider;



class CBasicCamera;
/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:
	typedef CFixedPool<CMyEntity>		TPool;

public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput();

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();

protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;
public:
	TPool*			mPool;

public:
	typedef CGrid<SSectorWithRayNuke,32,32>	TGrid;
	typedef std::list<CMyEntity*>	TEntityList; // list of pointers to entities
public:
	TGrid				mGrid;
	int					mTotalBads, mKilledBads;
	int					mTotalGoods, mKilledGoods;
	int					mTotalGods, mKilledGods;
	TEntityList			mGods;
	CJumpShotDecider*   mJumpDecider;
	CDieDecider*        mDieDecider;
};

#endif
