#pragma warning(disable:4786)

#include "MyGame.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include "../engine/TerrainPicker.h"
#include "SelDecider.h"

#include <cassert>


// ------------------------------------------------------------------
//  basic stuff


CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mPool( NULL )
{
}

CMyGame::~CMyGame()
{
	delete mPool;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input


void CMyGame::onMouseLChange( bool pressed )
{
	// respond to mouse left clicks
	D3DXVECTOR3 origin = getCamera().getPosition();
	D3DXVECTOR3 dir = getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() );
	if( pressed ) {
		// mouse pressed - begin drag
		mDragging = false;
		mDragValid = false;
		mSelectionHappened = false;
		CTerrainPick pick = CTerrainPicker::pick( getTerrain(), origin, dir );
		if( pick.isValid() ) {
			mDragging = true;
			mDragValid = true;
			mDragPointBegin = mDragPointEnd = pick.getLocation();
		}
	} else {
		// mouse released - end drag
		mDragging = false;
		mSelectionHappened = true;
	}
}

void CMyGame::onMouseRChange( bool pressed )
{
}

void CMyGame::onKeyChange( int key, bool pressed )
{
}

void CMyGame::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );

	// mouse move for dragging
	if( mDragging ) {
		D3DXVECTOR3 origin = getCamera().getPosition();
		D3DXVECTOR3 dir = getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() );
		CTerrainPick pick = CTerrainPicker::pick( getTerrain(), origin, dir );
		if( pick.isValid() ) {
			mDragValid = true;
			mDragPointEnd = pick.getLocation();
		}
	}
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	// not dragging
	mDragging = false;
	mDragValid = false;
	// one shared decider
	IDecider* decider = new CSelectionDecider();

	mTerrainCamera->setTerrain( getTerrain() );

	int maxEntities = getEntities().getMaxEntities();
	mPool = new TPool( maxEntities );

	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	int count = maxEntities/2;

	int i;


	for( i = 0; i < count; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = 1;
		e.mDecider = decider;

		e.setPicture( pic1 );
		e.setSize( 3.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = CMyEntity::F_GRAVITY;
	}
}


// ------------------------------------------------------------------
//  game logic


void CMyGame::onUpdate()
{
	// clear selection grid
	int n = mSelGrid.getSecsCount();
	for( int i = 0; i < n; ++i ) {
		mSelGrid.getSectorByIndex( i ).beginFrame();
	}

	// if we have just got a selection - put it into grid
	if( mSelectionHappened ) {
		CSelector<TSelectionGrid>::putSelection( mSelGrid, mDragPointBegin.x, mDragPointBegin.y, mDragPointEnd.x, mDragPointEnd.y );
		mSelectionHappened = false;
	}

	// update entities
	TPool::iterator it;
	for( it = mPool->begin(); it != mPool->end();  ) {
		CMyEntity& e = *it;
		assert( e.mDeciderCounter >= 0 );
		e.update();
		if( e.mFlags & CMyEntity::F_KILLED ) {
			it = mPool->erase( it );
			getEntities().remove( e );
		} else {
			++it;
		}
	}
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
	// draw selection over terrain
	if( mDragging && mDragValid ) {
		getTerrain().prepareQuad( mDragPointBegin.x, mDragPointBegin.y, mDragPointEnd.x, mDragPointEnd.y, 4.0f );
		getTerrain().renderQuad( 0x60FF0000 ); // slightly transparent, red color
	}
}
