
#ifndef __SEL_DECIDER_H
#define __SEL_DECIDER_H

#include "Decider.h"
#include "MyGame.h"


class CSelectionDecider : public IDecider {
public:
	virtual void decideFor( CMyEntity& e ) const {
		// get my sector
		float x = e.getPosition().x;
		float y = e.getPosition().y;
		const CMyGame::TSelectionGrid& grid = CMyGame::getInstance().mSelGrid;
		const CMyGame::TSelectionGrid::TSector& s = grid.getSectorByPosition( x, y );
		// see if i'm selected
		if( s.isSelected( x, y ) ) {
			// change my color (alpha at maximum)
			e.setColor( 0xFF000000 | (e.getColor() + 0x0073A93B) );
		}
		// decider gets called every update
		e.mDeciderCounter = 1; 
	};
};

#endif
