/**
 *  @file engine/Mesh.h
 *  Mesh renderer.
 */
#ifndef __MESH_H
#define __MESH_H

#include <d3d8.h>
#include <d3dx8effect.h>
#include "DXObject.h"
#include "resource/ResourceId.h"


class	CFrameTime;

class CMesh : public CDXObject
{
public:
	CMesh( CResourceId const& meshId, CResourceId const& effectId, CResourceId const& textureId );
	virtual ~CMesh();

	D3DXMATRIX const& getWorldMatrix() const { return mWorldMatrix; }
	D3DXMATRIX& getWorldMatrix() { return mWorldMatrix; }

	virtual HRESULT onCreateDevice( IDirect3DDevice8* device );
	virtual HRESULT onLostDevice();
	virtual HRESULT onResetDevice();
	virtual HRESULT onDestroyDevice();

	virtual void render( CFrameTime const& frameTime );

protected:
	virtual void applyEffectParameters( ID3DXEffect& effect );

private:
	D3DXMATRIX	mWorldMatrix;

	CResourceId	mMeshId;
	CResourceId mEffectId;
	CResourceId mTextureId;
};

#endif