#pragma warning(disable:4786)

#include "MyGame.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include <cassert>


// ------------------------------------------------------------------
//  basic stuff


CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mPool( NULL )
{
}

CMyGame::~CMyGame()
{
	delete mPool;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input


void CMyGame::onMouseLChange( bool pressed )
{
}

void CMyGame::onMouseRChange( bool pressed )
{
}

void CMyGame::onKeyChange( int key, bool pressed )
{
}

void CMyGame::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	mTerrainCamera->setTerrain( getTerrain() );

	int maxEntities = getEntities().getMaxEntities();
	mPool = new TPool( maxEntities );

	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	int count = maxEntities/2;

	int i;

	for( i = 0; i < count; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = NULL;
		e.setPicture( pic1 );
		e.setSize( 3.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = CMyEntity::F_GRAVITY;

		e.init();
	}

	const CPicture& p1 = *pb.getResourceById( CResourceId("Sprite.png") );
	const CPicture& p2 = *pb.getResourceById( CResourceId("God.png") );
	const CPicture& p3 = *pb.getResourceById( CResourceId("AngryGod.png") );

	mAnimationSet.add( p1 );
	mAnimationSet.add( p2 );
	mAnimationSet.add( p3 );

	static CMesh* mesh = new CMesh( 
		CResourceId( "cone10atzero.x" ),
		CResourceId( "TexturedMesh.sha" ),
		CResourceId( "TerrainGray.png" ) );
	mesh->getWorldMatrix()._11 = 10;
	mesh->getWorldMatrix()._22 = 10;
	mesh->getWorldMatrix()._33 = 20;
	mesh->getWorldMatrix()._41 = 300;
	mesh->getWorldMatrix()._42 = 400;

//	getObjects().addObject( *mesh );
}


// ------------------------------------------------------------------
//  game logic


void CMyGame::onUpdate()
{
	// update entities
	TPool::iterator it;
	for( it = mPool->begin(); it != mPool->end();  ) {
		CMyEntity& e = *it;
		assert( e.mDeciderCounter >= 0 );
		e.update();
		if( e.mFlags & CMyEntity::F_KILLED ) {
			it = mPool->erase( it );
			getEntities().remove( e );
		} else {
			++it;
		}
	}

	mAnimationSet.update( getHackFrameTimeForAnimation() );
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
}