#ifndef __ENTITY_H
#define __ENTITY_H

#include <d3dx8math.h>
#include "Sprite.h"

#pragma pack(1)

/**
 *  Base class for game entities.
 *
 *  Contains basic entity information (position, picture, etc.). All
 *  game entity classes should be child classes of this class.
 *
 *  Entity contains: position, old position, size, color and picture.
 *
 *  Position and old position are used by renderer to interpolate (because
 *  rendering and game updates happen at different frequencies). So in
 *  entity update code, first set old position to current position; and
 *  then change the position as you like.
 *
 *  @see CPicture, CPictureBundle.
 */
class CEntity {
public:

	//
	// public interface

	/// Returns read-only position.
	D3DXVECTOR3 const& getPosition() const { return mSpriteInfo.data->position; }
	/// Returns position.
	D3DXVECTOR3& getPosition() { return mSpriteInfo.data->position; }
	/// Returns read-only old position.
	D3DXVECTOR3 const& getOldPosition() const { return mSpriteInfo.data->oldPosition; }
	/// Returns old position.
	D3DXVECTOR3& getOldPosition() { return mSpriteInfo.data->oldPosition; }

	/// Returns size.
	float getSize() const { return mSpriteInfo.data->size; }
	/// Sets size.
	void setSize( float size ) { mSpriteInfo.data->size = size; }

	/// Returns color.
	D3DCOLOR getColor() const { return mSpriteInfo.data->color; }
	/// Sets color.
	void setColor( D3DCOLOR color ) { mSpriteInfo.data->color = color; }

	/// Returns read-only picture.
	CPicture const&	getPicture() const { return *mSpriteInfo.data->picture; }
	/// Sets picture.
	void setPicture( CPicture const& picture ) { mSpriteInfo.data->picture = &picture; }
	
	//
	// for CEntityRenderer

	void onAdd( SSpriteInfo spriteInfo );
	void onChange( SSpriteInfo newSpriteInfo, SSpriteInfo oldSpriteInfo );
	SSpriteInfo& onRemove();
	
//	SSpriteInfo const& getSpriteInfo() const { return mSpriteInfo; }
//	SSpriteInfo& getSpriteInfo() { return mSpriteInfo; }
	
private:
	SSpriteInfo			mSpriteInfo;
};

#pragma pack()

#endif