#ifndef __FRAME_TIME_H
#define __FRAME_TIME_H


class CFrameTime
{
public:
	CFrameTime( float time, float delta, int frameNumber, float updateFrequency )
		:	mTime( time ),
		mDelta( delta ),
		mAlpha( delta * updateFrequency ),
		mFrameNumber( frameNumber ) {}
	
	// Returns start time of the current frame in seconds as a float
	float getTime() const { return mTime; }
	// Returns time of the previous frame in seconds as a float
	float getDelta() const { return mDelta;	}

	float getAlpha() const { return mAlpha; }
	
	int getFrameNumber() const { return mFrameNumber; };
	
private:
	float			mTime;
	float			mDelta;
	float			mAlpha;
	int				mFrameNumber;
};

#endif