/**
 *  @file engine/Utils.h
 *  Some utils.
 */
#ifndef __UTILS_H
#define __UTILS_H

#include <d3dx8math.h>

/// Some utils.
namespace utils {
	/**
	 *  Bounds ray origin into the world.
	 *  @param or The origin (this is modified also).
	 *  @param dir The direction.
	 *  @param minZ Minimum world box Z coordinate.
	 *  @param maxZ Maximum world box Z coordinate.
	 *  @return false if ray does not intersect the world box.
	 */
	bool boundToWorld( D3DXVECTOR3& or, const D3DXVECTOR3& dir, float minZ, float maxZ );
};


#endif
