#include "AnimationSet.h"

#include <cassert>
#include "../FrameTime.h"

CAnimationSet::CAnimationSet()
{
}

void CAnimationSet::add(	CPicture const& pic )
{
	mPictures.push_back( &pic );
}

void CAnimationSet::update( CFrameTime const& frameTime )
{
	mCurrentTime = frameTime.getTime();
}

CPicture const& CAnimationSet::getPicture( float startTime, float animationSpeed ) const
{
	CPicture const* pic = 
		mPictures[ ((int)( ( mCurrentTime - startTime ) * animationSpeed )) % mPictures.size() ];

	assert( pic );
	return *pic;
}