#include "W32StdConsoleRenderingContext.h"
#include <cassert>


CW32StdConsoleRenderingContext::CW32StdConsoleRenderingContext( HWND handle )
:	mParentHandle( handle )
{
	AllocConsole();
	mConsoleHandle = GetStdHandle( STD_OUTPUT_HANDLE );

	assert( mConsoleHandle );
}

CW32StdConsoleRenderingContext::~CW32StdConsoleRenderingContext()
{
	FreeConsole();
}

void CW32StdConsoleRenderingContext::write( const std::string& message )
{
	DWORD charsWritten;
	WriteConsole( mConsoleHandle, message.c_str(), strlen( message.c_str() ), &charsWritten, NULL );
}
