#include "Keyboard.h"

#include <cassert>

CKeyboard::CKeyboard()
:	mListener( NULL )
{
	for( int q = 0; q < KEY_COUNT; ++q )
		mKeys[ q ] = false;
}

void CKeyboard::onMsgProc( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	switch( uMsg )
	{
	case WM_KEYDOWN:
		assert( wParam >= 0 && wParam < KEY_COUNT );

		if( !mKeys[ wParam ] && mListener )
			mListener->onKeyChange( wParam, true );
		mKeys[ wParam ] = true;
		break;
	case WM_KEYUP:
		assert( wParam >= 0 && wParam < KEY_COUNT );

		if( mKeys[ wParam ] && mListener )
			mListener->onKeyChange( wParam, false );
		mKeys[ wParam ] = false;
		break;
	};
}

bool CKeyboard::isKeyPressed( int key ) const
{
	assert( key >= 0 && key < KEY_COUNT );
	return mKeys[ key ];
}