#pragma warning(disable:4786)
#ifndef __BUNDLE_SINGLETON_H
#define __BUNDLE_SINGLETON_H

#include <cassert>
#include "../../utils/Singleton.h"


template <class T>
class CBundleSingleton : public CSingleton<T> {
private:
	static T* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( T& instance ) {
		delete &instance;
	}

	friend CSingleton<T>;
};

#endif
