#ifndef AfganistanConsts_Header
#define AfganistanConsts_Header

#include <string>

const int TOTAL_TREE_COUNT = 5766;
const float DEFAULT_TREE_SIZE = 7.0f;
const float TREE_LIFE = 6.0f;

const float DEFAULT_NUKE_SIZE = 15.0f;
const float DEFAULT_NUKE_HEIGHT = 200.0f;
const int NUKE_FIRE_COUNT = 1000;
const float NUKE_STRENGHTENING_LIFE = 0.04f;
const int MAX_NUKES = 10;
const int NUKE_COST = -25;

const float PLANE_AUTOTURN_DIST = 70;

const float FIRE_SPEED = 14.0f;
const float FIRE_ACCEL = 1.13f;
const float FIRE_SIZE = 6.0f;
const float FIRE_DAMAGE = 0.1f;
const float FIRE_LIFE = 0.58f;
const float FIRE_FADE_TIME = 0.30f;

const int TIME_PENALTY = 7;

const float PARTICLE_SIZE = 2.4f;
const int PARTICLES_LIMIT = 12000;

const int STAT_X = 7;
const int STAT_Y = 100;
const unsigned long int STAT_COLOR = 0xFFCC0333;
const int STAT_NEXT_Y = 20;

const unsigned long int RADAR_COLOR = 0x88FFFFFF;
const unsigned long int RADAR_ICON_COLOR = 0xFFFFFFFF;
const float RADAR_X = 0.45f;
const float RADAR_Y = -0.95f;
const float RADAR_WIDTH = 0.5f;
const float RADAR_HEIGHT = 0.7f;
const float RADAR_ICON_WIDTH = 0.025f;
const float RADAR_ICON_HEIGHT = 0.035f;

const int TALIBAN_COUNT[ 4 ] = {
	120,		//TALIB_KID
	600,	//TALIB_WOMAN
	350,	//TALIB_MAN
	10		//TALIB_BINLADEN
};
const int TOTAL_TALIBAN_COUNT = TALIBAN_COUNT[0] + TALIBAN_COUNT[1] + TALIBAN_COUNT[2] + TALIBAN_COUNT[3];

const std::string TALIBAN_PIC[ 4 ] = {
	"Taliban_kid01.png",	//TALIB_KID
	"Taliban_women01.png",	//TALIB_WOMAN
	"Taliban_men01.png",	//TALIB_MAN
	"BinLaden.png"			//TALIB_BINLADEN
};

const int TALIBAN_SPAWN_BLOOD[ 4 ] = {
	5,		//TALIB_KID
	11,		//TALIB_WOMAN
	14,		//TALIB_MAN
	80		//TALIB_BINLADEN
};

const float TALIBAN_SIZE[ 4 ] = {
	3.3f,		//TALIB_KID
	4.0f,		//TALIB_WOMAN
	5.0f,		//TALIB_MAN
	4.5f		//TALIB_BINLADEN
};

const int TALIBAN_KILL_SCORE[ 4 ] = {
	-10,	//TALIB_KID
	-4,		//TALIB_WOMAN
	-1,		//TALIB_MAN
	666		//TALIB_BINLADEN
};

const float TALIBAN_HEALTH[ 4 ] = {
	0.3f,	//TALIB_KID
	2.0f,	//TALIB_WOMAN
	3.0f,	//TALIB_MAN
	3.3f	//TALIB_BINLADEN
};

const std::string TALIBAN_NAME[ 4 ] = {
	"Talib kid",	//TALIB_KID
	"Talib woman",	//TALIB_WOMAN
	"Talib man",	//TALIB_MAN
	"Terorist"	//TALIB_BINLADEN
};

#endif	//AfganistanConsts_Header