#include "FireEntity.h"

#include "MyGame.h"
#include "MapGrid.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "AfganistanConsts.h"

void CFireEntity::init( float nLife )
{
//	mAnimator.init( 
//		CMyGame::getInstance().getAnimationSet(),
//		CMyGame::getInstance().getHackFrameTimeForAnimation() );
	mAlive = true;
	mLife = nLife;
}

void CFireEntity::update()
{
	getOldPosition() = getPosition();

	D3DXVECTOR3 pos = getPosition() + mVelocity;
	mVelocity.x *= FIRE_ACCEL;
	mVelocity.y *= FIRE_ACCEL;

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		pos.x = getOldPosition().x;
		mAlive = false;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		pos.y = getOldPosition().y;
		mAlive = false;
	}

	if( (mLife-=gcon::UPDATE_DT) < 0 )
		mAlive = false;
	else if( mLife < FIRE_FADE_TIME )
		setSize( FIRE_SIZE*mLife/FIRE_FADE_TIME );

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	pos.z = h;
	getPosition() = pos;

	// Do damage.
	CMapGrid::GetInstance().getSectorByPosition( getPosition() ).AddDamage( FIRE_DAMAGE );
}