#include "MapGrid.h"

const CSector &CMapGrid::getSectorByPosition( const D3DXVECTOR3 &pos ) const {
	return CGrid<CSector,64,64>::getSectorByPosition( pos.x, pos.y );
}

CSector &CMapGrid::getSectorByPosition( const D3DXVECTOR3 &pos ) {
	return CGrid<CSector,64,64>::getSectorByPosition( pos.x, pos.y );
}

void CMapGrid::UpdateAllSectors() {
	for( int index = 0; index < getSecsCount(); index++ )
		getSectorByIndex( index ).NextFrame();
}

CMapGrid &CMapGrid::GetInstance() {
	static CMapGrid cMapGrid;
	return cMapGrid;
}