#include "MyEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CMyEntity::init()
{
//	mAnimator.init( 
//		CMyGame::getInstance().getAnimationSet(),
//		CMyGame::getInstance().getHackFrameTimeForAnimation() );
}

void CMyEntity::update()
{
	//
	// set old position

	getOldPosition() = getPosition();

	//
	// decide (AI)

	if( mDecider ) {
		if( !mDeciderCounter ) {
			mDeciderCounter = DEFAULT_DECIDER_COUNTER;
			mDecider->decideFor( *this );
		}
		--mDeciderCounter;
	}

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	//
	// TODO: buildings

	//
	// terrain height

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	if( mFlags & F_KEEP_ON_TERRAIN ) {
		pos.z = h;
	} else {
		if( mFlags & F_GRAVITY ) {
			mVelocity.z -= gcon::GRAVITY;
		}
		if( pos.z < h ) {
			pos.z = h;
			mVelocity.z = 0.0f; // TODO: bounce off?
		}
	}

	if( pos.z <= h )
		mFlags |= F_TOUCHES_TERRAIN;
	else
		mFlags &= ~F_TOUCHES_TERRAIN;

	setPicture( mAnimator.getPicture() );

	getPosition() = pos;
}