#pragma warning(disable:4786)

#include "MyGame.h"
#include "MapGrid.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainPicker.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"
#include "TerrainModifier.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include <cassert>

#include "AfganistanConsts.h"

// ------------------------------------------------------------------
//  basic stuff


CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mNukePool( NULL ),
	mTreePool( NULL ),
	mTalibanPool( NULL ),
	mFirePool( NULL ),
	mParticlePool( NULL ),
	mNukeAdditionalLife( 0.0f )
{
}

CMyGame::~CMyGame()
{
	delete mNukePool;
	delete mTreePool;
	delete mTalibanPool;
	delete mFirePool;
	delete mParticlePool;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 110.0f );
	mTerrainCamera->doPitch( -0.365f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input


void CMyGame::onMouseLChange( bool pressed )
{
	// respond to mouse left clicks
    D3DXVECTOR3 origin = getCamera().getPosition();
    D3DXVECTOR3 dir = getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() );
    if( pressed && mNukePool->size() < MAX_NUKES-1 ) {
        CTerrainPick pick = CTerrainPicker::pick( getTerrain(), origin, dir );
        if( pick.isValid() ) {
            D3DXVECTOR3 posTarget = pick.getLocation();

			CPictureBundle& pb = CPictureBundle::getInstance();
			const CPicture& picNuke = *pb.getResourceById( CResourceId("Nuke.png") );
			CNukeEntity &rNukeEntity = mNukePool->add();
			getEntities().add( rNukeEntity );
			rNukeEntity.getPosition() = posTarget;
			rNukeEntity.getPosition().z += DEFAULT_NUKE_SIZE + DEFAULT_NUKE_HEIGHT;
			rNukeEntity.getOldPosition() = rNukeEntity.getPosition();
			rNukeEntity.setPicture( picNuke );
			rNukeEntity.setSize( DEFAULT_NUKE_SIZE );
			rNukeEntity.setColor( 0xFFFFFFFF );
			rNukeEntity.mVelocity = D3DXVECTOR3( 0.0f, 0.0f, -10.0f );
				
			rNukeEntity.init( posTarget.z );
			if( mNukeAdditionalLife<1.0f )
				mNukeAdditionalLife += NUKE_STRENGHTENING_LIFE;
        }
    }
}

void CMyGame::onMouseRChange( bool pressed )
{
}

void CMyGame::onKeyChange( int key, bool pressed )
{
}

void CMyGame::onProcessInput( float deltaTime )
{
	assert( mTerrainCamera );

	D3DXVECTOR3 PlayerPos = mTerrainCamera->getPosition();
	if( PlayerPos.x<PLANE_AUTOTURN_DIST || PlayerPos.x>gcon::WORLD_X-PLANE_AUTOTURN_DIST ||
		PlayerPos.y<PLANE_AUTOTURN_DIST || PlayerPos.y>gcon::WORLD_Y-PLANE_AUTOTURN_DIST ) {
		const D3DXMATRIX &m = mTerrainCamera->getCameraMatrix();
		D3DXVECTOR2 camera2D, toCenter2D;
		camera2D.x = m._11; camera2D.y = m._12;
		toCenter2D.x = gcon::WORLD_X/2 - PlayerPos.x;
		toCenter2D.y = gcon::WORLD_Y/2 - PlayerPos.y;
		D3DXVec2Normalize( &camera2D, &camera2D );
		D3DXVec2Normalize( &toCenter2D, &toCenter2D );
		D3DXVECTOR2 v2;
		v2.x = -camera2D.x;
		v2.y = -camera2D.y;
		if( D3DXVec2Dot( &v2, &toCenter2D )<0.0f )
			mTerrainCamera->doYaw( 2.0f*deltaTime );
		else mTerrainCamera->doYaw( -2.0f*deltaTime );
	} else {
		if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 2.0f*deltaTime );
		if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -2.0f*deltaTime );
	}
	mTerrainCamera->doMove( -120.0f*deltaTime );

}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	mTerrainCamera->setTerrain( getTerrain() );

	int maxEntities = getEntities().getMaxEntities();
	mNukePool = new TNukePool( MAX_NUKES );
	mTreePool = new TTreePool( TOTAL_TREE_COUNT );
	mTalibanPool = new TTalibanPool( TOTAL_TALIBAN_COUNT );
	mFirePool = new TFirePool( NUKE_FIRE_COUNT*MAX_NUKES );
	mParticlePool = new TParticlePool( PARTICLES_LIMIT );

	CPictureBundle& pb = CPictureBundle::getInstance();
//	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );
	const CPicture& picTree = *pb.getResourceById( CResourceId("Tree4_1.png") );
	const CPicture& picDamagedTree = *pb.getResourceById( CResourceId("tree4_2.png") );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -40.0f, 70.0f );

	int i;

	for( i = 0; i < TOTAL_TREE_COUNT; ++i ) {
		CTreeEntity& rTreeEntity = mTreePool->add();
		getEntities().add( rTreeEntity );
		float nPosX = random::randf(gcon::WORLD_X);
		float nPosY = random::randf(gcon::WORLD_Y);
		float nPosZ = CMyGame::getInstance().getTerrain().getAltitude( nPosX, nPosY ) + DEFAULT_TREE_SIZE;
		rTreeEntity.getPosition() = D3DXVECTOR3( nPosX, nPosY, nPosZ );
		rTreeEntity.getOldPosition() = rTreeEntity.getPosition();
		rTreeEntity.setPicture( picTree );
		rTreeEntity.setSize( DEFAULT_TREE_SIZE );
		rTreeEntity.setColor( 0xFFFFFFFF );
		
		rTreeEntity.init( picDamagedTree, TREE_LIFE );
	}

	for( int talibType = 0; talibType < CTalibanEntity::TALIB_TYPE_COUNT; ++talibType ) {
		const CPicture& picTaliban = *pb.getResourceById( CResourceId(TALIBAN_PIC[talibType]) );
		for( int i = 0; i < TALIBAN_COUNT[talibType]; ++i ) {
			CTalibanEntity& rTalibanEntity = mTalibanPool->add();
			getEntities().add( rTalibanEntity );
			float nPosX = random::randf(gcon::WORLD_X);
			float nPosY = random::randf(gcon::WORLD_Y);
			float nPosZ = CMyGame::getInstance().getTerrain().getAltitude( nPosX, nPosY );
			rTalibanEntity.getPosition() = D3DXVECTOR3( nPosX, nPosY, nPosZ );
			rTalibanEntity.getOldPosition() = rTalibanEntity.getPosition();
			rTalibanEntity.setPicture( picTaliban );
			rTalibanEntity.setColor( 0xFFFFFFFF );
			rTalibanEntity.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		
			rTalibanEntity.init( CTalibanEntity::EType(talibType) );
		}
	}

	cRadar.Init();

}

void CMyGame::AddParticles( std::string strName, int nCount, D3DXVECTOR3 posStart ) {
	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& ParticlePic = *pb.getResourceById( CResourceId(strName) );
	for( int particle=0; particle < nCount; ++particle )
		if( mParticlePool->hasSpace() ) {
			CParticleEntity& rParticleEntity = mParticlePool->add();
			getEntities().add( rParticleEntity );
			rParticleEntity.getPosition() = posStart;
			rParticleEntity.getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( rParticleEntity.getPosition().x, rParticleEntity.getPosition().y ) + PARTICLE_SIZE;
			rParticleEntity.getOldPosition() = rParticleEntity.getPosition();
			rParticleEntity.setPicture( ParticlePic );
			rParticleEntity.setSize( PARTICLE_SIZE );
			rParticleEntity.setColor( 0xFFFFFFFF );
			float nVelX = random::randfs( 3.0f );
			float nVelY = random::randfs( 3.0f );
			float nVelZ = 9.2f + random::randfs( 2.0f );
			rParticleEntity.mVelocity = D3DXVECTOR3( nVelX, nVelY, nVelZ );
			rParticleEntity.init();
			rParticleEntity.update();
		} else break;
}

void CMyGame::onUpdate()
{

	TTalibanPool::iterator TalibanIter;
	for( TalibanIter = mTalibanPool->begin(); TalibanIter != mTalibanPool->end();  ) {
		CTalibanEntity& oneTalibanEntity = *TalibanIter;
		oneTalibanEntity.update();
		if( oneTalibanEntity.DamageKilledThisOne() ) {
			AddParticles( "Blood01.png", TALIBAN_SPAWN_BLOOD[ oneTalibanEntity.mTalibType ], oneTalibanEntity.getPosition() );
			TalibanIter = mTalibanPool->erase( TalibanIter );
			getEntities().remove( oneTalibanEntity );
		} else ++TalibanIter;
	}

	TFirePool::iterator FireIter;
	for( FireIter = mFirePool->begin(); FireIter != mFirePool->end();  ) {
		CFireEntity& oneFire = *FireIter;
		oneFire.update();
		++FireIter;
	}


	//Nuke

	TNukePool::iterator NukeIter = mNukePool->begin();
	while( NukeIter != mNukePool->end() ) {
		CNukeEntity &rNuke = *NukeIter;
		rNuke.update();
		if( rNuke.explode() ) {
			CPictureBundle& pb = CPictureBundle::getInstance();
			const CPicture& picFire = *pb.getResourceById( CResourceId("Fire01.png") );
			for( int i = 0; i < NUKE_FIRE_COUNT; ++i ) {
				CFireEntity& rFireEntity = mFirePool->add();
				getEntities().add( rFireEntity );
				float nRadius = float( i ) / float( NUKE_FIRE_COUNT ) * D3DX_PI * 2;
				rFireEntity.getPosition() = rNuke.getPosition();
				rFireEntity.getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( rFireEntity.getPosition().x, rFireEntity.getPosition().y ) + FIRE_SIZE;
				rFireEntity.getOldPosition() = rNuke.getPosition();
				rFireEntity.setPicture( picFire );
				rFireEntity.setSize( FIRE_SIZE );
				rFireEntity.setColor( 0xFFFFFFFF );
				float nX = cosf( nRadius ) * FIRE_SPEED;
				float nY = sinf( nRadius ) * FIRE_SPEED;
				rFireEntity.mVelocity = D3DXVECTOR3( nX, nY, 0.0f );
				rFireEntity.init( FIRE_LIFE + mNukeAdditionalLife );
				rFireEntity.update();
			}
			/*CTerrain &Terra = getTerrain();
			Terra.beginUpdate();
			float height = Terra.getAltitude( rNuke.getPosition().x, rNuke.getPosition().y );
			Terra.setAltitude( rNuke.getPosition().x, rNuke.getPosition().y, height-10.0f );
			Terra.endUpdate();*/
			CTerrainModifier::raise( getTerrain(), rNuke.getPosition().x, rNuke.getPosition().y, 100.0f, -8.0f );

			NukeIter = mNukePool->erase( NukeIter );
			getEntities().remove( rNuke );
		} else ++NukeIter;
	}

	TFirePool::iterator TFireIter;
	for( TFireIter = mFirePool->begin(); TFireIter != mFirePool->end();  ) {
		CFireEntity& oneFireEntity = *TFireIter;
		if( !oneFireEntity.IsAlive() ) {
			TFireIter = mFirePool->erase( TFireIter );
			getEntities().remove( oneFireEntity );
		} else {
			++TFireIter;
		}
	}
	TTreePool::iterator TTreeIter;
	for( TTreeIter = mTreePool->begin(); TTreeIter != mTreePool->end();  ) {
		CTreeEntity& oneTreeEntity = *TTreeIter;
		if( oneTreeEntity.DamageKilledThisOne() ) {
			AddParticles( "Tree_part01.png", 6, oneTreeEntity.getPosition() );
			AddParticles( "Tree_part02.png", 24, oneTreeEntity.getPosition() );
			TTreeIter = mTreePool->erase( TTreeIter );
			getEntities().remove( oneTreeEntity );
		} else {
			++TTreeIter;
		}
	}

	TParticlePool::iterator ParticleIter;
	for( ParticleIter = mParticlePool->begin(); ParticleIter != mParticlePool->end();  ) {
		CParticleEntity& oneParticleEntity = *ParticleIter;
		oneParticleEntity.update();
		if( !oneParticleEntity.IsAlive() ) {
			ParticleIter = mParticlePool->erase( ParticleIter );
			getEntities().remove( oneParticleEntity );
		} else ++ParticleIter;
	}

	CMapGrid::GetInstance().UpdateAllSectors();
	mStatistics.TimePasses();
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll() {
	mStatistics.RenderStatistics();
	cRadar.DrawRadar();
}
