/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

//#include "MyEntity.h"
#include "TreeEntity.h"
#include "TalibanEntity.h"
#include "NukeEntity.h"
#include "FireEntity.h"
#include "ParticleEntity.h"
#include "Statistics.h"
#include "Radar.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

//#include "../engine/animator/AnimationSet.h"


class CBasicCamera;
/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:

public:
	typedef CFixedPool<CNukeEntity>		TNukePool;
	typedef CFixedPool<CTreeEntity>		TTreePool;
	typedef CFixedPool<CTalibanEntity>	TTalibanPool;
	typedef CFixedPool<CFireEntity>		TFirePool;
	typedef CFixedPool<CParticleEntity>	TParticlePool;
	
public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

//	CAnimationSet const& getAnimationSet() { return mAnimationSet; }

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput( float deltaTime );

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();


protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	friend CSingleton<CMyGame>;	

private:

//	CAnimationSet	mAnimationSet;

	float			mNukeAdditionalLife;

public:
	CRadar			cRadar;
	CBasicCamera*	mTerrainCamera;
	CStatistics		mStatistics;
//	TPool*			mPool;
	TTreePool*		mTreePool;
	TTalibanPool*	mTalibanPool;
	TFirePool*		mFirePool;
	TNukePool*		mNukePool;
	TParticlePool*	mParticlePool;

	void AddParticles( std::string strName, int nCount, D3DXVECTOR3 posStart );
};

#endif