#include "NukeEntity.h"

#include "MyGame.h"
#include "../engine/Terrain.h"
#include "AfganistanConsts.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CNukeEntity::init( float floor )
{
	mFloor = floor;
}

void CNukeEntity::update()
{
	getOldPosition() = getPosition();

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	if( pos.z < mFloor ) pos.z = mFloor;

	getPosition() = pos;
}

bool CNukeEntity::explode() {
	return getPosition().z <= mFloor + DEFAULT_NUKE_SIZE;
}
