#include "ParticleEntity.h"

#include "MyGame.h"
#include "../engine/Terrain.h"
#include "AfganistanConsts.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CParticleEntity::init()
{
	bAlive = true;
}

void CParticleEntity::update()
{
	getOldPosition() = getPosition();

	D3DXVECTOR3 pos = getPosition() + mVelocity;
	mVelocity.z -= 0.6f;
	float nFloor = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + PARTICLE_SIZE;

	if( pos.z < nFloor ) {
		pos.z = nFloor;
		bAlive = false;
	}

	getPosition() = pos;
}
