#include "Radar.h"
#include "MyGame.h"
#include "../engine/BillBoarder.h"
#include "../engine/camera/BasicCamera.h"
#include "AfganistanConsts.h"
#include "EngineConstants.h"

void CRadar::Init() {
}

void map2radar( D3DXVECTOR3 &pos ) {
	pos.x *= RADAR_WIDTH/gcon::WORLD_X;
	pos.y *= RADAR_HEIGHT/gcon::WORLD_Y;
	pos.x += RADAR_X - RADAR_ICON_WIDTH/2;
	pos.y += RADAR_Y - RADAR_ICON_HEIGHT/2;
}

void CRadar::DrawRadar() {
	CMyGame &rGame = CMyGame::getInstance();
	CBillboarder &rBillboarder = rGame.getBillboarder();
	
	rBillboarder.beginBillboards();

	rBillboarder.putScreenBill( CResourceId("Terrain.png"), RADAR_COLOR, RADAR_X, RADAR_Y, RADAR_X+RADAR_WIDTH , RADAR_Y+RADAR_HEIGHT ) ;

	D3DXVECTOR3 PlayerPosInRadar = rGame.mTerrainCamera->getPosition();
	map2radar( PlayerPosInRadar );
	rBillboarder.putScreenBill( CResourceId("Radar_planeplace.png"), RADAR_ICON_COLOR, PlayerPosInRadar.x, PlayerPosInRadar.y, PlayerPosInRadar.x+RADAR_ICON_WIDTH , PlayerPosInRadar.y+RADAR_ICON_HEIGHT ) ;

	TTerroristIter cTerroristIter = mTerroristList.begin();
	while( cTerroristIter != mTerroristList.end() ) {
		D3DXVECTOR3 TerroristPosInRadar = (*cTerroristIter)->getPosition();
		map2radar( TerroristPosInRadar );
		rBillboarder.putScreenBill( CResourceId("Radar_terroristplace.png"), RADAR_ICON_COLOR, TerroristPosInRadar.x, TerroristPosInRadar.y, TerroristPosInRadar.x+RADAR_ICON_WIDTH , TerroristPosInRadar.y+RADAR_ICON_HEIGHT ) ;
		++cTerroristIter;
	}

	rBillboarder.endBillboards();
}
