#include "Statistics.h"
#include "AfganistanConsts.h"
#include "MyGame.h"
#include "../engine/TextRenderer.h"

void CStatistics::Init() {
	for( int i = 0; i < CTalibanEntity::TALIB_TYPE_COUNT; i ++ )
		mTalibanKilled[ i ] = 0;
	mScore = 100;
	mTimePenalty = TIME_PENALTY;
}

void CStatistics::TalibanKilled( CTalibanEntity::EType eTalibType ) {
	mTalibanKilled[ eTalibType ]++;
	mScore += TALIBAN_KILL_SCORE[ eTalibType ];
}

std::string CStatistics::GetMsg( std::string strPreText, int value ) {
	char strNr[20];
	sprintf( strNr, "%i", value );
	return strPreText + strNr;
}

std::string CStatistics::GetTalibanKilledMsg( CTalibanEntity::EType eTalibType ) {
	return GetMsg( TALIBAN_NAME[eTalibType] + " killed: ", mTalibanKilled[eTalibType] );
}

std::string CStatistics::GetScoreMsg() {
	return GetMsg( "Score: ", mScore );
}

void CStatistics::RenderStatistics() {
	CTextRenderer &rTextRenderer = CMyGame::getInstance().getTextRenderer();
	rTextRenderer.renderScreenText( STAT_X, STAT_Y, GetScoreMsg(), STAT_COLOR );
	for( int i = 0; i < CTalibanEntity::TALIB_TYPE_COUNT; i ++ ) {
		std::string msg = GetTalibanKilledMsg( CTalibanEntity::EType(i) );
		rTextRenderer.renderScreenText( STAT_X, STAT_Y + STAT_NEXT_Y*(i+1), msg, STAT_COLOR );
	}
}

void CStatistics::TimePasses() {
	if( --mTimePenalty == 0 ) {
		mTimePenalty = TIME_PENALTY;
		mScore--;
	}
}

void CStatistics::NuckeDroped() {
	mScore += NUKE_COST;
}