#include "TalibanEntity.h"
#include "AfganistanConsts.h"

#include "Decider.h"
#include "MyGame.h"
#include "MapGrid.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CTalibanEntity::init( EType eTalibType ) {
	mTalibType = eTalibType;
	mHealth = TALIBAN_HEALTH[ eTalibType ];
	setSize( TALIBAN_SIZE[ eTalibType ] );
	getPosition().z += TALIBAN_SIZE[ eTalibType ];
	getOldPosition().z += TALIBAN_SIZE[ eTalibType ];
	if( eTalibType == TALIB_BINLADEN )
		CMyGame::getInstance().cRadar.AddTerrorist( this );
}

void CTalibanEntity::update()
{
	//
	// set old position

	getOldPosition() = getPosition();

	//
	// decide (AI)

//	if( mDecider )
//		if( !--mDeciderCounter ) {
//			mDeciderCounter = DECIDE_COUNT;
//			mDecider->decideFor( *this );
//		}

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	pos.z = h;

	getPosition() = pos;
}

bool CTalibanEntity::DamageKilledThisOne() {
	float damage = (CMapGrid::GetInstance()).getSectorByPosition( getPosition() ).GetCurrentDamage();
	mHealth -= damage;
	bool bKilled = mHealth <= 0.0f;
	if( bKilled ) {
		CMyGame::getInstance().mStatistics.TalibanKilled( mTalibType );
		if( mTalibType == TALIB_BINLADEN )
			CMyGame::getInstance().cRadar.RemTerrorist( this );
	}
	return bKilled;
}
