#pragma warning( disable:4786 )
#include "Mesh.h"

#include "resource/MeshBundle.h"
#include "resource/EffectBundle.h"
#include "resource/TextureBundle.h"
#include "../utils/DXHelpers.h"
#include "../utils/Errors.h"


CMesh::CMesh( CResourceId const& meshId, CResourceId const& effectId, CResourceId const& textureId )
:	mMeshId( meshId ), mEffectId( effectId ), mTextureId( textureId )
{
	D3DXMatrixIdentity( &mWorldMatrix );
}

CMesh::~CMesh()
{
}

HRESULT CMesh::onCreateDevice( IDirect3DDevice8* device )
{
	return CDXObject::onCreateDevice( device );
}

HRESULT CMesh::onLostDevice()
{
	return CDXObject::onLostDevice();
}

HRESULT CMesh::onResetDevice()
{
	return CDXObject::onResetDevice();
}

HRESULT CMesh::onDestroyDevice()
{
	return CDXObject::onDestroyDevice();
}

void CMesh::render( CFrameTime const& frameTime )
{
	ID3DXMesh* mesh = CMeshBundle::getInstance().getResourceById( mMeshId );
	ID3DXEffect* effect = CEffectBundle::getInstance().getResourceById( mEffectId );

	assert( mesh );
	assert( effect );
	
	applyEffectParameters( *effect );
	
	UINT passes;
	effect->Begin( &passes, 0 );

	// render
	for( int p = 0; p < passes; ++p )
	{
		effect->Pass( p );

		// render mesh
		// NOTE: doesn't support vertex shaders
		// ID3DXBaseMesh::DrawSubset() method uses fixed function pipeline
		HRESULT hres;
		hres = mesh->DrawSubset( 0 );
		if( !SUCCEEDED( hres ) ) {
			THROW_DXERROR( hres, "failed to render mesh" );
		}

	}

	effect->End();
}

void CMesh::applyEffectParameters( ID3DXEffect& effect )
{
	IDirect3DTexture8* texture = CTextureBundle::getInstance().getResourceById( mTextureId );
	assert( texture );

	effect.SetTexture( "texBase", texture );
	effect.SetMatrix( "matWorld", &mWorldMatrix );
}