
#include "TerrainGen.h"
#include "Terrain.h"
#include "../utils/Random.h"
#include "resource/TextureBundle.h"


void CTerrainGen::fillTexture( CTerrain& terrain, const CResourceId& texID, float zMin, float zMax )
{
	std::string fileName = CTextureBundle::getInstance().getPreDir() + texID.getUniqueName();
	IDirect3DDevice8& device = CTextureBundle::getInstance().getDevice();

	IDirect3DTexture8* texture = NULL;
	D3DXCreateTextureFromFileEx(
		&device, fileName.c_str(), CTerrain::CELLS_X, CTerrain::CELLS_Y, 1,
		0, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM, D3DX_DEFAULT, D3DX_DEFAULT, 0, 0, 0, &texture
	);
	if( !texture ) {
		fillConst( terrain, 0.0f );
		return;
	}

	RECT rect;
	rect.left = 0; rect.right = CTerrain::CELLS_X-1;
	rect.top = 0; rect.bottom = CTerrain::CELLS_Y-1;
	D3DLOCKED_RECT lr;
	texture->LockRect( 0, &lr, &rect, D3DLOCK_READONLY );

	terrain.beginUpdate();
	for( int y = 0; y < CTerrain::CELLS_Y; ++y ) {
		for( int x = 0; x < CTerrain::CELLS_X; ++x ) {
			BYTE* pixel = (BYTE*)lr.pBits + y*lr.Pitch + x*4;
			terrain.setAltitude( x, y, zMin + (zMax-zMin) * pixel[2] / 255.0f );
		}
	}
	terrain.endUpdate();

	texture->UnlockRect( 0 );
}


void CTerrainGen::fillConst( CTerrain& terrain, float z )
{
	terrain.beginUpdate();
	for( int y = 0; y < CTerrain::CELLS_Y; ++y ) {
		for( int x = 0; x < CTerrain::CELLS_X; ++x ) {
			terrain.setAltitude( x, y, z );
		}
	}
	terrain.endUpdate();
}

void CTerrainGen::fillRandom( CTerrain& terrain, float zMin, float zMax )
{
	float zRange = zMax-zMin;

	terrain.beginUpdate();
	for( int y = 0; y < CTerrain::CELLS_Y; ++y ) {
		for( int x = 0; x < CTerrain::CELLS_X; ++x ) {
			terrain.setAltitude( x, y, zMin + random::randf(zRange) );
		}
	}
	terrain.endUpdate();
}

void CTerrainGen::addConst( CTerrain& terrain, float z )
{
	terrain.beginUpdate();
	for( int y = 0; y < CTerrain::CELLS_Y; ++y ) {
		for( int x = 0; x < CTerrain::CELLS_X; ++x ) {
			terrain.setAltitude( x, y, terrain.getAltitudeIdx( x, y ) + z );
		}
	}
	terrain.endUpdate();
}
