/**
 *  @file engine/resource/MeshBundle.h
 *  Mesh bundle.
 */
#pragma warning( disable:4786 )
#ifndef __MESH_BUNDLE_H
#define __MESH_BUNDLE_H

#include "BundleSingleton.h"
#include "StorageResourceBundle.h"


/**
 *  Mesh bundle.
 *  Mesh loading and shared access happens here. It's a singleton via
 *  static getInstance() method.
 *  @see CResourceId, IResourceBundle#getResourceById, IResourceBundle#rejectResource, IResourceBundle#clear.
 */
class CMeshBundle : public CStorageResourceBundle<ID3DXMesh>, public CBundleSingleton<CMeshBundle>
{
public:
	static void init( IDirect3DDevice8& device, std::string const& predir = "" ) {
		CMeshBundle* bundle = new CMeshBundle( device, predir );
		assert( bundle );
		assignInstance( *bundle );
	}
	
protected:
	virtual ID3DXMesh* loadResourceById( CResourceId const& id );
	virtual void touchResource( ID3DXMesh& resource );	
	virtual void clearResource( ID3DXMesh& resource );
	
private:
	CMeshBundle( IDirect3DDevice8& device, std::string const& predir = "" );
	virtual ~CMeshBundle();
	friend CBundleSingleton<CMeshBundle>;

private:
	std::string	const	mPreDir;
	IDirect3DDevice8&	mDevice;
};

#endif