#ifndef __HOME_H
#define __HOME_H

#include <d3dx8math.h>

class CHome
{
public:
	CHome( /*D3DXVECTOR3 const& position*/ )
		: mPosition( 0, 0, 0 ), mSize( 1000.0f ), mOldSize( mSize ), mMinProductionSize( 100.0f ),
		mWarriorProduceFactor( 0.0f ),
		mHarvesterProduceFactor( 0.0f ),
		mVultureProduceFactor( 0.0f ),
	
		mWarriorProduce( 0.0f ),
		mHarvesterProduce( 0.0f ),
		mVultureProduce( 0.0f ),
	
		mTeamFlag( 0 ),
		mModifier( 1.0f ) {}

	void init();
	void produce();

	void reduce( float strength ) {
		mSize -= strength;
	}

	void grow( float strength ) {
		mSize += strength;
	}

public:
	D3DXVECTOR3	mPosition;

	D3DXVECTOR3	mWarriorProducerPosition;
	D3DXVECTOR3	mHarversterProducerPosition;
	D3DXVECTOR3	mVultureProducerPosition;

	float		mSize;
	float		mOldSize;
	float		mMinProductionSize;

	float		mWarriorProduceFactor;
	float		mHarvesterProduceFactor;
	float		mVultureProduceFactor;

	float		mWarriorProduce;
	float		mHarvesterProduce;
	float		mVultureProduce;

	short		mTeamFlag;

	D3DCOLOR	mWarriorColor;
	D3DCOLOR	mHarvesterColor;
	D3DCOLOR	mVultureColor;

	float		mModifier;
};

#endif