#include "MyEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CMyEntity::init()
{
	if( mFlags & F_VULTURE )
	{
		if( mFlags & F_OVERLORD )
		{
			mAnimator.init(
				CMyGame::getInstance().mOverlordHAnimationSet,
				CMyGame::getInstance().getHackFrameTimeForAnimation() );
		}
		else
		{
			mAnimator.init(
				CMyGame::getInstance().mVultureAnimationSet,
				CMyGame::getInstance().getHackFrameTimeForAnimation() );
		}
	}
	else if( mFlags & F_HARVERSTER )
	{
		if( mFlags & F_OVERLORD )
		{
			mAnimator.init(
				CMyGame::getInstance().mOverlordHAnimationSet,
				CMyGame::getInstance().getHackFrameTimeForAnimation() );
		}
		else
		{
			mAnimator.init( 
				CMyGame::getInstance().mHarvesterAnimationSet,
				CMyGame::getInstance().getHackFrameTimeForAnimation() );
		}
	}
	else if( mFlags & F_WARRIOR )
	{
		if( mFlags & F_OVERLORD )
		{
			mAnimator.init(
				CMyGame::getInstance().mOverlordHAnimationSet,
				CMyGame::getInstance().getHackFrameTimeForAnimation() );
		}
		else
		{
			mAnimator.init( 
				CMyGame::getInstance().mWarriorAnimationSet,
				CMyGame::getInstance().getHackFrameTimeForAnimation() );
		}
	}

/*	mAnimator.init( 
		CMyGame::getInstance().getAnimationSet(),
		CMyGame::getInstance().getHackFrameTimeForAnimation() );*/

	mVolume = 0.5f;
}

void CMyEntity::update()
{
	//
	// set old position

	getOldPosition() = getPosition();

	//
	// decide (AI)

	if( mDecider ) {
		if( mDeciderCounter <= 0 ) {
			mDeciderCounter = DEFAULT_DECIDER_COUNTER;
			mDecider->decideFor( *this );
		}
		--mDeciderCounter;
	}

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}


	//
	// TODO: buildings

	//
	// terrain height

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	SMySector& sector = CMyGame::getInstance().mGrid.getSectorByPosition( 
		pos.x,
		pos.y );

	if( sector.freeSpace > 0 )
	{
		sector.freeSpace -= mVolume;
		if( mFlags & F_COLLIDED )
		{
			mFlags &= ~F_COLLIDED;
		}
	}
	else
	{
		mDeciderCounter = DEFAULT_DECIDER_COUNTER;

		if( mFlags & F_COLLIDED )
		{
//			mFlags &= ~F_COLLIDED;
		}
		else
		{
//			mVelocity = -mVelocity;
			float speed = D3DXVec3Length( &mVelocity );
			mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
			D3DXVec3Normalize( &mVelocity, &mVelocity );
			mVelocity *= speed;
//			mFlags |= F_COLLIDED;
		}
	}

	if( mFlags & F_KEEP_ON_TERRAIN ) {
		pos.z = h + 10.0f;
	} else {
		if( mFlags & F_GRAVITY ) {
			mVelocity.z -= gcon::GRAVITY;
		}
		if( pos.z < h ) {
			pos.z = h;
			mVelocity.z = 0.0f; // TODO: bounce off?
		}
	}

	if( pos.z <= h )
		mFlags |= F_TOUCHES_TERRAIN;
	else
		mFlags &= ~F_TOUCHES_TERRAIN;

	setPicture( mAnimator.getPicture() );
	getPosition() = pos;


	// job
	int teamNr = ( mFlags & F_TEAM ) >> 8;
	CTeam& team = CMyGame::getInstance().getTeam( teamNr );

	if( mFlags & F_WARRIOR )
	{
		sector.damage += mStrength;
		sector.wdamage[teamNr] += mStrength;

		if( sector.wpastDamage[teamNr] )
		{
			mFlags |= F_KILLED;
		}
	}
	else 
	{
		//sector.wdamage[teamNr] += 0.001f;

		if( sector.pastDamage )
		{
			sector.pastDamage -= mEnergy;

			if( sector.pastDamage <= 0 )
			{
				mEnergy = -sector.pastDamage;
			}
			else
			{
				mFlags |= F_KILLED;
				return;
			}
		}

		if( mFlags & F_HARVERSTER )
		{
			if( mStrength > 0.0f )
			{
				sector.harvesting += mStrength;
				if( sector.grass >= sector.harvesting )
				{
					// bring harvest home
					setColor( 0xFFa0a0a0 );
//					setSize( 5.0f );

					mFood = mStrength;
					mStrength = 0.0f;

					mDecider = &team.mGoHomeH;
					mDeciderCounter = 1;
				}
			}
		}
		else if( mFlags & F_VULTURE )
		{
//			if( sector.pastDamage )
//			{
//				mFlags |= F_KILLED;
//			}
			if( mStrength > 0.0f )
			{
				sector.vulturing += mStrength;
				if( sector.corpses >= sector.vulturing )
				{
					// bring harvest home
					setColor( 0xFFa0a0a0 );
//					setSize( 3.0f );

					mFood = mStrength;
					mStrength = 0.0f;

					mDecider = &team.mGoHomeV;
					mDeciderCounter = 1;
				}

			}
		}
	}
}

void CFoodEntity::init()
{
	SMySector& sector = CMyGame::getInstance().mGrid.getSectorByPosition( 
		getPosition().x,
		getPosition().y );

	getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( getPosition().x, getPosition().y ) + getSize();
	getOldPosition() = getPosition();

	if( mFlags & F_GRASS )
	{
		mAnimator.init( 
		CMyGame::getInstance().mGrassAnimationSet,
		CMyGame::getInstance().getHackFrameTimeForAnimation() );

		mVolume = 5.0f;

		sector.grass += mVolume;
	}
	else
	{
		mAnimator.init( 
		CMyGame::getInstance().mCorpseAimationSet,
		CMyGame::getInstance().getHackFrameTimeForAnimation() );

		mVolume = 1.0f;

		sector.corpses += mVolume;
		mLifeTime = 600;
	}
}

void CFoodEntity::update()
{
	setPicture( mAnimator.getPicture() );

	SMySector& sector = CMyGame::getInstance().mGrid.getSectorByPosition( 
		getPosition().x,
		getPosition().y );

	mLifeTime--;

	if( !mLifeTime && mFlags & F_CORPSE )
	{
		mFlags |= F_GRASS;
		mFlags &= ~F_CORPSE;
		sector.corpses -= mVolume;
		init();
	}

	if( sector.harvesting > 0 && mFlags & F_GRASS )
	{
		sector.harvesting -= mVolume;
		sector.grass -= mVolume;
		mFlags |= F_HARVESTED;
	}

	if( sector.vulturing > 0 && mFlags & F_CORPSE )
	{
		sector.vulturing -= mVolume;
		sector.corpses -= mVolume;
		mFlags |= F_HARVESTED;
	}
}