/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"
#include "../engine/animator/Animator.h"

class IDecider;

#pragma pack(1)


/**
 *  Your game entity.
 */
class CMyEntity : public CEntity {
public:
	enum {
		F_KEEP_ON_TERRAIN = 1,
		F_GRAVITY = 2,
		F_TOUCHES_TERRAIN = 4,
		F_COLLIDED = 8,
		F_KILLED = 16,

		F_WARRIOR = 32,
		F_HARVERSTER = 64,
		F_VULTURE = 128,

		F_TEAM = 256,

		F_OVERLORD = 512
		
	};
	enum { DEFAULT_DECIDER_COUNTER = 30 };

public:
	void	init();
	void	update();
	
public:
	D3DXVECTOR3	mVelocity;
	short		mFlags;
	short		mDeciderCounter;
	IDecider*	mDecider;

	CAnimator<2.0f>	mAnimator;

	float		mVolume;
	float		mStrength;
	float		mFood;

	float		mEnergy;
};

class CFoodEntity : public CEntity
{
public:
	enum {
		F_GRASS = 1,
		F_CORPSE = 2,
		F_HARVESTED = 4
	};

public:
	void init();
	void update();

public:
	short		mFlags;

	CAnimator<2.0f>	mAnimator;
	float		mVolume;
	int			mLifeTime;
};

class COverlordEntity : public CMyEntity
{
};

#pragma pack()

#endif