#pragma warning(disable:4786)

#include "MyGame.h"
#include "Decider.h"
#include "../engine/EntityRenderer.h"
#include "../engine/TextRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/TerrainPicker.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include <cassert>


// ------------------------------------------------------------------
//  basic stuff

CTeam::CTeam()
:	mSelectedOverlord( NULL ),

	mFollowOverlordV( mOverLordV, 2.0f ),
	mFollowOverlordH( mOverLordH, 3.0f ),
	mFollowOverlordW( mOverLordW, 1.5f ),

	mGoHomeV( mHome, mFollowOverlordV, 2.0f, 0xFF0000FF ),
	mGoHomeH( mHome, mFollowOverlordH, 3.0f, 0xFF00FF00 )
{
}

CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mPool( NULL ),
	mActiveTeam( 0 )
{
	mTeam[0].mHome.mTeamFlag = 0;
	mTeam[1].mHome.mTeamFlag = CMyEntity::F_TEAM;
}

CMyGame::~CMyGame()
{
	delete mPool;
	delete mFoodPool;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input


void CMyGame::onMouseLChange( bool pressed )
{
    D3DXVECTOR3 origin = getCamera().getPosition();
    D3DXVECTOR3 dir = getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() );

	if( !pressed && getActiveTeam().mSelectedOverlord )
	{
		CTerrainPick pick = CTerrainPicker::pick( getTerrain(), origin, dir );
		if( pick.isValid() )
		{
			getActiveTeam().mSelectedOverlord->getPosition() = pick.getLocation();
			getActiveTeam().mSelectedOverlord->getOldPosition() = pick.getLocation();
		}
	}
}

void CMyGame::onMouseRChange( bool pressed )
{
}

void CMyGame::onKeyChange( int key, bool pressed )
{
}

void CMyGame::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );

	if( getKeyboard().isKeyPressed('1') )		getActiveTeam().mSelectedOverlord = &getActiveTeam().mTargetOverLordV;
	if( getKeyboard().isKeyPressed('2') )		getActiveTeam().mSelectedOverlord = &getActiveTeam().mTargetOverLordH;
	if( getKeyboard().isKeyPressed('3') )		getActiveTeam().mSelectedOverlord = &getActiveTeam().mTargetOverLordW;

	if( getKeyboard().isKeyPressed('Y') )		getActiveTeam().mHome.mVultureProduceFactor+=0.1f;
	if( getKeyboard().isKeyPressed('U') )		getActiveTeam().mHome.mHarvesterProduceFactor+=0.1f;
	if( getKeyboard().isKeyPressed('I') )		getActiveTeam().mHome.mWarriorProduceFactor+=0.1f;

	if( getKeyboard().isKeyPressed('H') )		getActiveTeam().mHome.mVultureProduceFactor-=0.1f;
	if( getKeyboard().isKeyPressed('J') )		getActiveTeam().mHome.mHarvesterProduceFactor-=0.1f;
	if( getKeyboard().isKeyPressed('K') )		getActiveTeam().mHome.mWarriorProduceFactor-=0.1f;


	getActiveTeam().mHome.mVultureProduceFactor = max( getActiveTeam().mHome.mVultureProduceFactor, 0.0f );
	getActiveTeam().mHome.mHarvesterProduceFactor = max( getActiveTeam().mHome.mHarvesterProduceFactor, 0.0f );
	getActiveTeam().mHome.mWarriorProduceFactor = max( getActiveTeam().mHome.mWarriorProduceFactor, 0.0f );
}


// ------------------------------------------------------------------
//  initialization

bool CMyGame::hasSpace() const
{
	return getEntities().getEntityCount() < getEntities().getMaxEntities();
}


void CMyGame::onInitialize()
{
	mTerrainCamera->setTerrain( getTerrain() );

	int maxEntities = getEntities().getMaxEntities();
	mPool = new TPool( maxEntities );
	mFoodPool = new TFoodPool( maxEntities );


	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	int count = maxEntities/6;

	int i;

/*	static CFollowOverlord follow1( mOverLord1 );
	static CFollowOverlord follow2( mOverLord2 );
	static CFollowOverlord follow3( mOverLord3 );*/

	for( int q = 0; q < TEAM_COUNT; ++q )
	{
		// mem leak
		CFollowOverlord* tfollow1 = new CFollowOverlord( mTeam[q].mTargetOverLordV, 5.0f, 0.005f );
		CFollowOverlord* tfollow2 = new CFollowOverlord( mTeam[q].mTargetOverLordH, 5.0f, 0.005f );
		CFollowOverlord* tfollow3 = new CFollowOverlord( mTeam[q].mTargetOverLordW, 5.0f, 0.005f );


		CTeam& team = mTeam[q];


		if( q == 0 )
		{
			team.mHome.mPosition = D3DXVECTOR3( 170, 850, 0.0f );

			team.mHome.mWarriorColor = 0xffff0000;
			team.mHome.mHarvesterColor = 0xffffff00;
			team.mHome.mVultureColor = 0xffff8000;

			team.mGoHomeH.mColor = 0xffffff00;
			team.mGoHomeV.mColor = 0xffff8000;

			team.mHome.mModifier = 1.0f;
		}
		else
		{
			team.mHome.mPosition = D3DXVECTOR3( 850, 170, 0.0f );

			team.mHome.mWarriorColor = 0xff0000ff;
			team.mHome.mHarvesterColor = 0xff00ffff;
			team.mHome.mVultureColor = 0xff00ff80;

			team.mGoHomeH.mColor = 0xff00ffff;
			team.mGoHomeV.mColor = 0xff00ff80;

			team.mHome.mModifier = -1.0f;
		}

		team.mHome.init();


		getEntities().add( team.mOverLordV );
		team.mOverLordV.getPosition() = team.mHome.mVultureProducerPosition;
		team.mOverLordV.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		team.mOverLordV.getOldPosition() = team.mOverLordV.getPosition();
		team.mOverLordV.mDeciderCounter = rand()&15;
		team.mOverLordV.mDecider = tfollow1;
		team.mOverLordV.setPicture( pic1 );
		team.mOverLordV.setSize( 10.0f );
		team.mOverLordV.setColor( team.mHome.mVultureColor );
		team.mOverLordV.mFlags = CMyEntity::F_KEEP_ON_TERRAIN | CMyEntity:: F_VULTURE | CMyEntity::F_OVERLORD;
		team.mOverLordV.init();

		getEntities().add( team.mOverLordH );
		team.mOverLordH.getPosition() = team.mHome.mHarversterProducerPosition;
		team.mOverLordH.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		team.mOverLordH.getOldPosition() = team.mOverLordH.getPosition();
		team.mOverLordH.mDeciderCounter = rand()&15;
		team.mOverLordH.mDecider = tfollow2;
		team.mOverLordH.setPicture( pic1 );
		team.mOverLordH.setSize( 10.0f );
		team.mOverLordH.setColor( team.mHome.mHarvesterColor );
		team.mOverLordH.mFlags = CMyEntity::F_KEEP_ON_TERRAIN | CMyEntity:: F_HARVERSTER | CMyEntity::F_OVERLORD;
		team.mOverLordH.init();

		getEntities().add( team.mOverLordW );
		team.mOverLordW.getPosition() = team.mHome.mWarriorProducerPosition;
		team.mOverLordW.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		team.mOverLordW.getOldPosition() = team.mOverLordW.getPosition();
		team.mOverLordW.mDeciderCounter = rand()&15;
		team.mOverLordW.mDecider = tfollow3;
		team.mOverLordW.setPicture( pic1 );
		team.mOverLordW.setSize( 10.0f );
		team.mOverLordW.setColor( team.mHome.mWarriorColor );
		team.mOverLordW.mFlags = CMyEntity::F_KEEP_ON_TERRAIN | CMyEntity:: F_WARRIOR | CMyEntity::F_OVERLORD;
		team.mOverLordW.init();



		getEntities().add( team.mTargetOverLordV );
		team.mTargetOverLordV.getPosition() = team.mHome.mVultureProducerPosition;
		team.mTargetOverLordV.mVelocity = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
		team.mTargetOverLordV.getOldPosition() = team.mTargetOverLordV.getPosition();
		team.mTargetOverLordV.mDeciderCounter = 0;
		team.mTargetOverLordV.mDecider = NULL;
		team.mTargetOverLordV.setPicture( pic1 );
		team.mTargetOverLordV.setSize( 0.0f );
		team.mTargetOverLordV.setColor( team.mHome.mVultureColor );
		team.mTargetOverLordV.mFlags = CMyEntity::F_KEEP_ON_TERRAIN | CMyEntity:: F_VULTURE | CMyEntity::F_OVERLORD;
		team.mTargetOverLordV.init();

		getEntities().add( team.mTargetOverLordH );
		team.mTargetOverLordH.getPosition() = team.mHome.mHarversterProducerPosition;
		team.mTargetOverLordH.mVelocity = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
		team.mTargetOverLordH.getOldPosition() = team.mTargetOverLordH.getPosition();
		team.mTargetOverLordH.mDeciderCounter = 0;
		team.mTargetOverLordH.mDecider = NULL;
		team.mTargetOverLordH.setPicture( pic1 );
		team.mTargetOverLordH.setSize( 0.0f );
		team.mTargetOverLordH.setColor( team.mHome.mHarvesterColor );
		team.mTargetOverLordH.mFlags = CMyEntity::F_KEEP_ON_TERRAIN | CMyEntity:: F_HARVERSTER | CMyEntity::F_OVERLORD;
		team.mTargetOverLordH.init();

		getEntities().add( team.mTargetOverLordW );
		team.mTargetOverLordW.getPosition() = team.mHome.mWarriorProducerPosition;
		team.mTargetOverLordW.mVelocity = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
		team.mTargetOverLordW.getOldPosition() = team.mTargetOverLordW.getPosition();
		team.mTargetOverLordW.mDeciderCounter = 0;
		team.mTargetOverLordW.mDecider = NULL;
		team.mTargetOverLordW.setPicture( pic1 );
		team.mTargetOverLordW.setSize( 0.0f );
		team.mTargetOverLordW.setColor( team.mHome.mWarriorColor );
		team.mTargetOverLordW.mFlags = CMyEntity::F_KEEP_ON_TERRAIN | CMyEntity:: F_WARRIOR | CMyEntity::F_OVERLORD;
		team.mTargetOverLordW.init();
	}

/*	for( i = 0; i < count; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = &follow1;
//		e.mDecider = &mGoHome;
		e.setPicture( pic1 );
		e.setSize( 3.0f );
		e.setColor( 0xFF0000FF );
		e.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_VULTURE;
		e.mStrength = 1.0f;

		e.init();
	}

	for( i = 0; i < count; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = &follow2;
		e.setPicture( pic1 );
		e.setSize( 3.0f );
		e.setColor( 0xFF00FF00 );
		e.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_HARVERSTER;

		e.mStrength = 1.0f;

		e.init();
	}

	for( i = 0; i < count; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = &follow3;
		e.setPicture( pic1 );
		e.setSize( 3.0f );
		e.setColor( 0xFFFF0000 );
		e.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_WARRIOR;

		e.mStrength = 1.0f;
		

		e.init();
	}*/

	// food
	for( i = 0; i < count * 3; ++i ) {
		CFoodEntity& e = mFoodPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( gcon::WORLD_X/2 - gcon::WORLD_X/20 + random::randf(gcon::WORLD_X/10)  , random::randf(gcon::WORLD_Y), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.setPicture( pic1 );
		e.setSize( 1.5f );
		e.setColor( 0xFFFFFFFF );

		e.mFlags = CFoodEntity::F_GRASS;

		e.init();
	}




	const CPicture& p1 = *pb.getResourceById( CResourceId("Sprite.png") );
	const CPicture& p2 = *pb.getResourceById( CResourceId("Arboozas.png") );
	const CPicture& p3 = *pb.getResourceById( CResourceId("Corpse3.png") );

	const CPicture& w1 = *pb.getResourceById( CResourceId("Fighter1.png") );
	const CPicture& w2 = *pb.getResourceById( CResourceId("Fighter2.png") );

	const CPicture& h1 = *pb.getResourceById( CResourceId("Worker1.png") );
	const CPicture& h2 = *pb.getResourceById( CResourceId("Worker2.png") );

	const CPicture& v1 = *pb.getResourceById( CResourceId("Corpse1.png") );
	const CPicture& v2 = *pb.getResourceById( CResourceId("Corpse2.png") );

	const CPicture& ow1 = *pb.getResourceById( CResourceId("Fighter_over2_1.png") );
	const CPicture& ow2 = *pb.getResourceById( CResourceId("Fighter_over2_2.png") );

	const CPicture& oh1 = *pb.getResourceById( CResourceId("Worker_over1.png") );
	const CPicture& oh2 = *pb.getResourceById( CResourceId("Worker_over2.png") );

	const CPicture& ov1 = *pb.getResourceById( CResourceId("Corpse_over1.png") );
	const CPicture& ov2 = *pb.getResourceById( CResourceId("Corpse_over2.png") );


	mAnimationSet.add( p1 );
//	mAnimationSet.add( p2 );
//	mAnimationSet.add( p3 );


	mOverlordHAnimationSet.add( oh1 );
	mOverlordHAnimationSet.add( oh2 );

	mOverlordVAnimationSet.add( ov1 );
	mOverlordVAnimationSet.add( ov2 );

	mOverlordWAnimationSet.add( ow1 );
	mOverlordWAnimationSet.add( ow2 );


	mHarvesterAnimationSet.add( h1 );
	mHarvesterAnimationSet.add( h2 );

	mVultureAnimationSet.add( v1 );
	mVultureAnimationSet.add( v2 );

	mWarriorAnimationSet.add( w1 );
	mWarriorAnimationSet.add( w2 );

	mGrassAnimationSet.add( p2 );
	mCorpseAimationSet.add( p3 );

	static CMesh* mesh = new CMesh( 
		CResourceId( "cone10atzero.x" ),
		CResourceId( "TexturedMesh.sha" ),
		CResourceId( "TerrainGray.png" ) );
	mesh->getWorldMatrix()._11 = 10;
	mesh->getWorldMatrix()._22 = 10;
	mesh->getWorldMatrix()._33 = 20;
	mesh->getWorldMatrix()._41 = 300;
	mesh->getWorldMatrix()._42 = 400;

//	getObjects().addObject( *mesh );
}


// ------------------------------------------------------------------
//  game logic


void CMyGame::onUpdate()
{
	const CPicture& p = *CPictureBundle::getInstance().getResourceById( CResourceId("God.png") );
	
	mGrid.onUpdateBegin();
	for( int q = 0; q < 32; ++q )
		mGrid.getSectorByIndex( q, 12 ).freeSpace = 0.0f;

	for( int w = 0; w < TEAM_COUNT; w++ )
	{
		CTeam& team = mTeam[w];

		// update entities
		team.mOverLordV.mDeciderCounter = 0;
		team.mOverLordH.mDeciderCounter = 0;
		team.mOverLordW.mDeciderCounter = 0;

		team.mOverLordV.update();
		team.mOverLordH.update();
		team.mOverLordW.update();

		team.mHome.produce();
	}


	TPool::iterator it;
	for( it = mPool->begin(); it != mPool->end();  ) {
		CMyEntity& e = *it;
		assert( e.mDeciderCounter >= 0 );
		e.update();
		if( e.mFlags & CMyEntity::F_KILLED ) {
			CFoodEntity& c = mFoodPool->add();
			getEntities().add( c );
			c.getPosition() = e.getPosition();
			c.getOldPosition() = e.getPosition();
			c.setPicture( p );
			c.setSize( e.getSize() );
			c.setColor( 0xFFFFFFFF );

			c.mFlags = CFoodEntity::F_CORPSE;

			c.init();

			it = mPool->erase( it );
			getEntities().remove( e );

		} else {
			++it;
		}
	}

	TFoodPool::iterator it2;
	for( it2 = mFoodPool->begin(); it2 != mFoodPool->end();  ) {
		CFoodEntity& e = *it2;
		e.update();
		if( e.mFlags & CFoodEntity::F_HARVESTED ) {
			it2 = mFoodPool->erase( it2 );
			getEntities().remove( e );
		} else {
			++it2;
		}
	}

	static int counter = 0;
	counter++;
	if( counter > 100 ) 
	{
		switchTeam();
		counter = 0;
	}

	mOverlordVAnimationSet.update( getHackFrameTimeForAnimation() );
	mOverlordHAnimationSet.update( getHackFrameTimeForAnimation() );
	mOverlordWAnimationSet.update( getHackFrameTimeForAnimation() );

	mVultureAnimationSet.update( getHackFrameTimeForAnimation() );
	mHarvesterAnimationSet.update( getHackFrameTimeForAnimation() );
	mWarriorAnimationSet.update( getHackFrameTimeForAnimation() );

	mGrassAnimationSet.update( getHackFrameTimeForAnimation() );
	mCorpseAimationSet.update( getHackFrameTimeForAnimation() );

	mAnimationSet.update( getHackFrameTimeForAnimation() );
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
	char* str = new char[33];
	itoa( (int)mTeam[0].mHome.mSize, str, 10 );
	getTextRenderer().renderScreenText( 10, 30, str );

	itoa( (int)mTeam[1].mHome.mSize, str, 10 );
	getTextRenderer().renderScreenText( 10, 50, str );

	itoa( (int)mActiveTeam, str, 10 );
	getTextRenderer().renderScreenText( 10, 70, str );

	itoa( (int)getEntities().getEntityCount(), str, 10 );
	getTextRenderer().renderScreenText( 10, 90, str );
}