/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "Home.h"
#include "Decider.h"
#include "MyEntity.h"
#include "MySector.h"

#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

#include "../engine/animator/AnimationSet.h"
#include "../engine/Grid.h"




class CBasicCamera;
class CTeam
{
public:
	CTeam();

public:
	COverlordEntity		mOverLordV;
	COverlordEntity		mOverLordH;
	COverlordEntity		mOverLordW;

	COverlordEntity		mTargetOverLordV;
	COverlordEntity		mTargetOverLordH;
	COverlordEntity		mTargetOverLordW;

	COverlordEntity*	mSelectedOverlord;

	CFollowOverlord		mFollowOverlordV;
	CFollowOverlord		mFollowOverlordH;
	CFollowOverlord		mFollowOverlordW;

	CHome				mHome;
	CGoHome				mGoHomeV;
	CGoHome				mGoHomeH;
};


class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:
	enum { TEAM_COUNT = 2 };

public:
	typedef CFixedPool<CMyEntity>	TPool;
	typedef CFixedPool<CFoodEntity>	TFoodPool;

public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();


	void switchTeam() {
		mActiveTeam++;
		if( mActiveTeam >= TEAM_COUNT )
			mActiveTeam = 0;
	}

	CTeam& getActiveTeam() {
		return mTeam[ mActiveTeam ];
	}

	CTeam& getTeam( int team ) {
		assert( team >= 0 && team < TEAM_COUNT );
		return mTeam[team];
	}

	CTeam& getTeamByHome( CHome& home ) {
		for( int q = 0; q < TEAM_COUNT; ++q )
			if( &mTeam[q].mHome == &home )
				return mTeam[q];

		return mTeam[0];
	}


	CAnimationSet const& getAnimationSet() { return mAnimationSet; }
	bool hasSpace() const;

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput();

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();


protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;

	CAnimationSet	mAnimationSet;

public:
	typedef CGrid<SMySector,128,128>   TMyGrid;

	TMyGrid				mGrid;

	TPool*				mPool;
	TFoodPool*			mFoodPool;

/*	COverlordEntity		mOverLordV;
	COverlordEntity		mOverLordH;
	COverlordEntity		mOverLordW;

	COverlordEntity		mTargetOverLordV;
	COverlordEntity		mTargetOverLordH;
	COverlordEntity		mTargetOverLordW;

	COverlordEntity*	mSelectedOverlord;

	CFollowOverlord		mFollowOverlordV;
	CFollowOverlord		mFollowOverlordH;
	CFollowOverlord		mFollowOverlordW;

	CHome				mHome;
	CGoHome				mGoHomeV;
	CGoHome				mGoHomeH;*/

	CTeam				mTeam[2];
	int					mActiveTeam;

	CAnimationSet		mOverlordVAnimationSet;
	CAnimationSet		mOverlordHAnimationSet;
	CAnimationSet		mOverlordWAnimationSet;

	CAnimationSet		mVultureAnimationSet;
	CAnimationSet		mHarvesterAnimationSet;
	CAnimationSet		mWarriorAnimationSet;


	CAnimationSet		mGrassAnimationSet;
	CAnimationSet		mCorpseAimationSet;
};

#endif