#ifndef __MY_SECTOR_H
#define __MY_SECTOR_H


struct SMySector
{
public:
	enum { TEAM_COUNT = 2 };

public:
	SMySector() 
		: freeSpace( 3.0f ),
		damage( 0 ),
		pastDamage( 0 ),
		grass( 0 ),
		harvesting( 0 ),
		corpses( 0 ),
		vulturing( 0 ) {
		for( int q = 0; q < TEAM_COUNT; ++q ) {
			wdamage[q] = 0.0f;
			wpastDamage[q] = 0.0f;
		}
	}

	void onUpdateBegin() {
		freeSpace = 3.0f;

		pastDamage = damage; damage = 0.0f;

		for( int q = 0; q < TEAM_COUNT; ++q ) {
			wpastDamage[q] = 0;
		}

		for(	q = 0; q < TEAM_COUNT; ++q ) {
			for( int w = 0; w < TEAM_COUNT; ++w )
			{
				if( w != q )
					wpastDamage[w] += wdamage[q];
			}
			wdamage[q] = 0.0f;
		}

		harvesting = 0.0f;
		vulturing = 0.0f;
	}

public:
	float	freeSpace;

	float	damage;
	float	pastDamage;

	float	wdamage[TEAM_COUNT];
	float	wpastDamage[TEAM_COUNT];

	float	grass;
	float	harvesting;

	float	corpses;
	float	vulturing;
};

#endif