
#ifndef __VERTICES_H
#define __VERTICES_H

#include <d3dx8math.h>

#pragma pack(1)

// Vertex format: position.
const DWORD FVF_XYZ = D3DFVF_XYZ;
// Vertex: position.
struct SVertexXyz {
	D3DXVECTOR3	p;
};

// Vertex format: position, normal.
const DWORD FVF_XYZ_NORMAL = D3DFVF_XYZ | D3DFVF_NORMAL;
// Vertex: position, normal.
struct SVertexXyzNormal {
	D3DXVECTOR3	p;
	D3DXVECTOR3	n;
};

// Vertex format: position, UV.
const DWORD FVF_XYZ_TEX1 = D3DFVF_XYZ | D3DFVF_TEX1;
// Vertex: position, UV.
struct SVertexXyzTex1 {
	D3DXVECTOR3	p;
	float tu, tv;
};

// Vertex format: position, color.
const DWORD FVF_XYZ_DIFFUSE = D3DFVF_XYZ | D3DFVF_DIFFUSE;
// Vertex: position, color.
struct SVertexXyzDiffuse {
	D3DXVECTOR3	p;
	DWORD diffuse;
};

// Vertex format: position, color, UV.
const DWORD FVF_XYZ_DIFFUSE_TEX1 = D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1;
// Vertex: position, color, UV.
struct SVertexXyzDiffuseTex1 {
	D3DXVECTOR3	p;
	DWORD diffuse;
	float tu, tv;
};

// Vertex format: transformed position, UV.
const DWORD FVF_XYZRHW_TEX1 = D3DFVF_XYZRHW | D3DFVF_TEX1;
// Vertex: transformed position, UV.
struct SVertexXyzRhwTex1 {
	D3DXVECTOR4	p;
	float tu, tv;
};

// Vertex format: transformed position, color, UV.
const DWORD FVF_XYZRHW_DIFFUSE_TEX1 = D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1;
// Vertex: transformed position, color, UV.
struct SVertexXyzRhwDiffuseTex1 {
	D3DXVECTOR4	p;
	DWORD diffuse;
	float tu, tv;
};

// Vertex format: position, normal, UV.
const DWORD FVF_XYZ_NORMAL_TEX1 = D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1;
// Vertex: position, normal, UV.
struct SVertexXyzNormalTex1 {
	D3DXVECTOR3	p;
	D3DXVECTOR3	n;
	float tu, tv;
};

// Vertex format: position, normal, color, UV.
const DWORD FVF_XYZ_NORMAL_DIFFUSE_TEX1 = D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1;
// Vertex: position, normal, color, UV.
struct SVertexXyzNormalDiffuseTex1 {
	D3DXVECTOR3	p;
	D3DXVECTOR3	n;
	DWORD diffuse;
	float tu, tv;
};

// Vertex format: position, normal, color.
const DWORD FVF_XYZ_NORMAL_DIFFUSE = D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE;
// Vertex: position, normal, color.
struct SVertexXyzNormalDiffuse {
	D3DXVECTOR3	p;
	D3DXVECTOR3	n;
	DWORD diffuse;
};

#pragma pack()

#endif
