#pragma warning(disable:4786)
#ifndef __RESOURCE_BUNDLE_H
#define __RESOURCE_BUNDLE_H

#include "ResourceId.h"
#include "../console/Console.h"


/**
 *  Templated resource bundle interface.
 *
 *  Base template interface for all resource bundles.
 *  @param T Resource class.
 */
template<class T>
class IResourceBundle {
protected:
	static con::CChannel& CONSOLE;
	static con::CChannel& CON_WARNING;
	static con::CChannel& CON_ERROR;
	
public:
	virtual ~IResourceBundle() = 0 {};

	/// Gets resource by ID.
	virtual T* getResourceById( CResourceId const& id ) = 0;
	/// Clears resource by ID.
	virtual void rejectResource( CResourceId const& id ) = 0;
	/// Clears whole bundle.
	virtual void clear() = 0;
};

template<class T>
con::CChannel& IResourceBundle<T>::CONSOLE = con::CConsole::getChannel( "resource" );

template<class T>
con::CChannel& IResourceBundle<T>::CON_WARNING = con::CConsole::getChannel( "warning" );

template<class T>
con::CChannel& IResourceBundle<T>::CON_ERROR = con::CConsole::getChannel( "error" );


#endif
