#include "BallEntity.h"

#include "MyGame.h"
#include "EngineConstants.h"
#include "../engine/Terrain.h"

const float CBallEntity::GRAVITY = 7.0f;

CBallEntity::CBallEntity()
:	mClick( 0 )
{
	//setSize( 0 );
}

void CBallEntity::update()
{
	CBallSector& sLast = CMyGame::getInstance().getGrid()->getSectorByPosition( getOldPosition().x, getOldPosition().y );
    //if( sLast.mBall == this ) sLast.mBall = NULL;
	sLast.removeBall( *this );

	CBallSector& sNow = CMyGame::getInstance().getGrid()->getSectorByPosition( getPosition().x, getPosition().y );
    //sNow.mBall = this;
	sNow.addBall( *this );


	D3DXVECTOR3 pos = getOldPosition() = getPosition();

	float d = 5;

	D3DXVECTOR3 v1( pos.x - d, pos.y, 0 );
	if( v1.x < 0 ) v1.x = 0;
	D3DXVECTOR3 v2( pos.x, pos.y - d, 0 );
	if( v2.y < 0 ) v2.y = 0;

	v1 = D3DXVECTOR3( d, 0,
		CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) -
		CMyGame::getInstance().getTerrain().getAltitude( v1.x, v1.y ) );

	v2 = D3DXVECTOR3( 0, d,
		CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) -
		CMyGame::getInstance().getTerrain().getAltitude( v2.x, v2.y ) );

	D3DXVECTOR3 normal;

	D3DXVec3Cross( &normal, &v1, &v2 );
	D3DXVec3Normalize( &normal, &normal );

	const float inf = 0.3f;
	
	D3DXVECTOR3 v = normal * fabsf( GRAVITY ) * 3;
	v.z -= GRAVITY;

	mVelocity = ( mVelocity + v * inf ) * 0.9f;

	pos += mVelocity;

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	pos.z = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	

	getPosition() = pos;
}

void CBallEntity::resetPosition( const D3DXVECTOR3& p )
{
	getOldPosition() = getPosition() = p;
	setSize( 10 );
	mVelocity = D3DXVECTOR3( 0, 0, 0 );
	mSzSq = getSize() * getSize();
	mClick++;
	mTime = 0;
	mRotA = 0;
}

void CBallEntity::addGodless()
{
	setSize( getSize() + 0.1f );
	if( getSize() > 50 ) setSize( 50 );
	mSzSq = getSize() * getSize();
}