#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"
#include "MyEntity.h"

#include "../utils/Random.h"
#include "CloudEntity.h"

CCloudEntity::CCloudEntity() 
:	a( random::randf( 5 )), 
	r( random::randf( gcon::WORLD_X >> 1 )),
	mPictureId( NULL )
{
}

void CCloudEntity::update() 
{
	getOldPosition() = getPosition();
	D3DXVECTOR3 pos = getPosition();

	// my pos
	
	D3DXVECTOR3 v (D3DXVECTOR3( sin( a ) * r + gcon::WORLD_X / 2, cos( a ) * r + gcon::WORLD_Y / 2 , 250 ));
	a+= 0.1f;
	pos = v;

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}
	
	getPosition() = pos;
}

