#include "GodlessEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../utils/Random.h"
#include "MyEntity.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

CGodlessEntity::CGodlessEntity()
:	mBall( NULL ), mOxigen( 255 )
{
}

void CGodlessEntity::update()
{
	getOldPosition() = getPosition();
	D3DXVECTOR3 d( gcon::WORLD_X * 0.5 - getPosition().x, gcon::WORLD_Y * 0.5 - getPosition().y, 0 );

	bool found = D3DXVec3LengthSq( &d ) < CMyGame::STONE_RADIUS_2;

	if( !CMyGame::getInstance().mGameStarted ) {
		if( D3DXVec3LengthSq( &d ) < CMyGame::STONE_RADIUS_2 * 9 ) {
			getOldPosition() = getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );

			found = false;
		}
	}

	if( mOxigen >= 0 ) {
		if( !mBall ) {
			if( !found ) {
				CMyEntity::update();

				getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( getPosition().x, getPosition().y ) + getSize();;


				CBallSector& s = CMyGame::getInstance().getGrid()->getSectorByPosition( getPosition().x, getPosition().y );
				s.assignToBall( *this );

				/*if( s.mBall ) {
					D3DXVECTOR3 d = getPosition() - s.mBall->getPosition();
					if( D3DXVec3LengthSq( &d ) < s.mBall->mSzSq ) {
						mBall = s.mBall;
						
						d = D3DXVECTOR3( random::randfs(3.0f), random::randfs(3.0f), random::randfs(3.0f) );
						D3DXVec3Normalize( &d, &d );
						d *= s.mBall->getSize() * 0.5f;

						mBallVector = d;

						mBall->addGodless();
						mClick = mBall->mClick;
					}
				}*/
			}
		} else {
			if( mClick != mBall->mClick ) {
				mBall = NULL;

				mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randfs(3.0f), 0.0f );
			} else {
				getOldPosition() = getPosition();
				D3DXVECTOR3 pos = mBall->getPosition() + mBallVector;
				
				if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
					mVelocity.x = -mVelocity.x;
					pos.x = getOldPosition().x;
				}
				if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
					mVelocity.y = -mVelocity.y;
					pos.y = getOldPosition().y;
				}

				getPosition() = pos;
			}
		}

		if( getPosition().z  < 0 ) {
			setColor( 0xff000000 + ( mOxigen << 16 ) + ( mOxigen << 8 ) + 0xff );
			mOxigen--;			
		} else {
			mOxigen++;
			if( mOxigen > 255 ) mOxigen = 255;
		}
	} else {
		getOldPosition() = getPosition();
		setColor( 0xffff0000 );
		if( getPosition().z > 500 ) mFlags |= F_KILLED;
		else getPosition().z += 5;
	}

	if( found ) {
		setColor( 0xffffffff );
		if( getPosition().z > 500 ) mFlags |= F_KILLED;
		else getPosition().z += 5;
	}
}