#include "GodlessEntityDecider.h"

#include <cassert>
#include "..\engine\Terrain.h"
#include "MyEntity.h"

CGodlessEntityDecider::CGodlessEntityDecider( CTerrain& terrain, const D3DXVECTOR3& godPosition, float influence )
:	mTerrain( terrain ), mGodPosition( godPosition ), mInfluence( influence )
{
	assert( mInfluence < 1 );
}

void CGodlessEntityDecider::decideFor( CMyEntity& e ) const 
{
	D3DXVECTOR3 v = mGodPosition - e.getPosition();
	v *= 0.01f;
	e.mVelocity = e.mVelocity * ( 1.0f - mInfluence ) + v * mInfluence;

	e.getPosition().z = mTerrain.getAltitude( e.getPosition().x, e.getPosition().y );
}
