/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"

class IDecider;

#pragma pack(1)


/**
 *  Your game entity.
 */
class CMyEntity : public CEntity {
public:
	enum {
		F_KEEP_ON_TERRAIN = 1,
		F_GRAVITY = 2,
		F_TOUCHES_TERRAIN = 4,
		F_KILLED = 8
	};
	enum { DEFAULT_DECIDER_COUNTER = 1 };

public:
	virtual void	update();
	
public:
	D3DXVECTOR3		mVelocity;
	short			mFlags;
	short			mDeciderCounter;
	IDecider*		mDecider;
};

#pragma pack()


#endif
