#pragma warning(disable:4786)

//#include <d3dx8math.h>
#include "MyGame.h"
#include "../engine/Billboarder.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainPicker.h"
#include "../engine/TerrainGen.h"
#include "../engine/TextRenderer.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"
#include "../engine/animator/Animator.h"
#include "../engine/animator/AnimationSet.h"
#include "../utils/Config.h"

#include "MyTerrainGen.h"
#include "GodlessEntity.h"
#include "GodlessEntityDecider.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include <cassert>


const int CBallSector::MAX_BALLS = 10;

CBallSector::CBallSector() 
: mBalls( new TBallEntityPtrPool( MAX_BALLS ) ) 
{
	for( int i = 0; i < MAX_BALLS; i++ )
		mBalls->add( NULL );
}

CBallSector::CBallSector( const CBallSector& s )
{
	mBalls = new TBallEntityPtrPool( s.mBalls->capacity() );
	for( TBallEntityPtrPool::iterator it = s.mBalls->begin(); it != s.mBalls->end(); it++ )
		mBalls->add( *it );
}

CBallSector::~CBallSector()
{
	delete mBalls;
}

void CBallSector::assignToBall( CGodlessEntity& entity )
{
	for( TBallEntityPtrPool::iterator it = mBalls->begin(); it != mBalls->end(); it++ ) {
		if( *it ) {
			CBallEntity* b = *it;

			D3DXVECTOR3 d = entity.getPosition() - b->getPosition();
			if( D3DXVec3LengthSq( &d ) < b->mSzSq ) {
				entity.mBall = b;
						
				d = D3DXVECTOR3( random::randfs(3.0f), random::randfs(3.0f), random::randfs(3.0f) );
				D3DXVec3Normalize( &d, &d );
				d *= b->getSize() * 0.5f;

				entity.mBallVector = d;

				entity.mBall->addGodless();
				entity.mClick = entity.mBall->mClick;

				return;
			}
		}
	}
}

void CBallSector::addBall( CBallEntity& ball )
{
	for( TBallEntityPtrPool::iterator it = mBalls->begin(); it != mBalls->end(); it++ ) {
		if( !*it ) {
			*it = &ball;
		
			return;
		}
	}
}

void CBallSector::removeBall( CBallEntity& ball )
{
	for( TBallEntityPtrPool::iterator it = mBalls->begin(); it != mBalls->end(); it++ ) {
		if( *it == &ball ) {
			*it = NULL;
		
			return;
		}
	}
}


// ------------------------------------------------------------------
//  basic stuff

int CMyGame::BALL_COUNT = 50;
const int CMyGame::CLOUD_COUNT = 30;
int CMyGame::GODLESS_COUNT = 10000;
const float CMyGame::STONE_RADIUS = 30;
const float CMyGame::STONE_RADIUS_2 = STONE_RADIUS * STONE_RADIUS;

CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mPool( NULL ),
	mGodlessEntityPool( NULL ),
	mBallEntityPool( NULL ),
	mCloudEntityPool( NULL ),
	mCurrentBall( 0 ),
	mGrid( NULL ),
	mTerrainWater( NULL ),
	mGodlessDeadCount( 0 ),
	mGodFound( 0 ),
	mM2Pressed( false ),
	mGameStarted( false )
{
}

CMyGame::~CMyGame()
{
	delete mPool;
	delete mGodlessEntityPool;
	delete mBallEntityPool;
	delete mCloudEntityPool;
	delete mGrid;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input

/*struct SRaySector {
	bool        mHasRay;
	D3DXVECTOR3 mOrigin; // origin of the ray
	D3DXVECTOR3 mDir;    // direction of the ray
};
typedef CGrid<SRaySector> TRayGrid;*/


void CMyGame::onMouseLChange( bool pressed )
{
	//mGameStarted = true;

	if( pressed ) putBall();
}

void CMyGame::putBall()
{
	if( mGameStarted ) {
		D3DXVECTOR3 dir = getCamera().getCameraRay( getMouse().getMouseX(), getMouse().getMouseY() );
		D3DXVECTOR4 dir4;

		D3DXMATRIX m = getCamera().getCameraMatrix();
		m._41 = m._42 = m._43 = 0;

		D3DXVec3Transform( &dir4, &dir, &m );
		dir.x = dir4.x;
		dir.y = dir4.y;
		dir.z = dir4.z;

		CTerrainPick pick = CTerrainPicker::pick( getTerrain(), getCamera().getPosition(), dir );

		if( pick.isValid() ) {
			assert( mCurrentBall < mBallEntityPool->size() );
			TBallEntityPool::iterator it;
			int i = 0;
			for( it = mBallEntityPool->begin(); i < mCurrentBall; i++, it++ );

			it->resetPosition( pick.getLocation() );

			mCurrentBall++;
			if( mCurrentBall >= mBallEntityPool->size() ) mCurrentBall = 0;
		}
	}
}

void CMyGame::onMouseRChange( bool pressed )
{
	//mGameStarted = true;

	mM2Pressed = pressed;
}

void CMyGame::onKeyChange( int key, bool pressed )
{
	if( ( key == VK_RETURN ) && pressed ) mGameStarted = true;
}

void CMyGame::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );
	if( getKeyboard().isKeyPressed(VK_SPACE) ) { orientCamera(); }
}


void CMyGame::initCamera() 
{
	D3DXVECTOR3 center( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, getTerrain().getAltitude( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f ) );

	mTerrainCamera->getPosition() = center + D3DXVECTOR3( 0, 150, 150 );

	orientCamera();
}

void CMyGame::orientCamera()
{
	D3DXVECTOR3 center( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, getTerrain().getAltitude( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f ) );
	D3DXVECTOR3 d = center - mTerrainCamera->getPosition();
	float l = D3DXVec3Length( &d );
	D3DXVec3Normalize( &d, &d );
		
	D3DXVECTOR3 front = d;
	D3DXVECTOR3 up = mTerrainCamera->getUp();
	D3DXVECTOR3 right = mTerrainCamera->getRight();

	up = D3DXVECTOR3( 0, 0, 1 );

	front = d;
	D3DXVec3Cross( &right, &front, &up );		
	D3DXVec3Cross( &up, &right, &front );

	D3DXVec3Normalize( &front, &front );
	D3DXVec3Normalize( &up, &up );
	D3DXVec3Normalize( &right, &right );

	mTerrainCamera->getFront() = front;
	mTerrainCamera->getUp() = up;
	mTerrainCamera->getRight() = right;
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	BALL_COUNT = getConfig().readI( "game", "maxBalls", 100 );
	GODLESS_COUNT = getConfig().readI( "game", "godless", 2000 );

	mTerrainCamera->setTerrain( getTerrain() );

	

	mTerrainWater = new CTerrain( 
		CResourceId( "TerrainWater.sha" ), 
		//CResourceId( "TerrainGray.png" ), 
		CResourceId( "Water.png" ), 
		1, 1 );
	CTerrainGen::fillConst( *mTerrainWater, 0.0f );

	//CTerrainGen::fillTexture( *mTerrainWater, CResourceId(""), 0.0f, 0.0f );
	//getTerrain().setTexture( CResourceId(  ) );

	
	getObjects().addObject( *mTerrainWater );

	int maxEntities = getEntities().getMaxEntities();
	//mPool = new TPool( maxEntities );
	mPool = new TPool( 20 );
	mGodlessEntityPool = new TGodlessEntityPool( maxEntities );
	mBallEntityPool = new TBallEntityPool( BALL_COUNT );
	mCloudEntityPool = new TCloudEntityPool( CLOUD_COUNT );

	mGrid = new TBallGrid();

	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& picGodless = *pb.getResourceById( CResourceId("Sprite.png") );
	const CPicture& picStone = *pb.getResourceById( CResourceId("Stone.png") );
	const CPicture& picDogbert = *pb.getResourceById( CResourceId("Dogbert.png") );

	//const CPicture& picBall = *pb.getResourceById( CResourceId("AngryGod.png") );
	/*const CPicture* picCloud[4];
	picCloud[0] = pb.getResourceById( CResourceId("cloud0.png") );
	picCloud[1] = pb.getResourceById( CResourceId("cloud1.png") );
	picCloud[2] = pb.getResourceById( CResourceId("cloud2.png") );
	picCloud[3] = pb.getResourceById( CResourceId("cloud3.png") );*/

	CResourceId* picCloud[4];
	picCloud[0] = new CResourceId("cloud0.png");
	picCloud[1] = new CResourceId("cloud1.png");
	picCloud[2] = new CResourceId("cloud2.png");
	picCloud[3] = new CResourceId("cloud3.png");

	const CPicture* picBall[4];
	picBall[0] = pb.getResourceById( CResourceId("sb0.png") );
	picBall[1] = pb.getResourceById( CResourceId("sb1.png") );
	picBall[2] = pb.getResourceById( CResourceId("sb2.png") );
	picBall[3] = pb.getResourceById( CResourceId("sb3.png") );
	
	//CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );
	//getTerrain().setTexture( CResourceId( "TerrainGray.png" ) );
	//CTerrainGen::fillTexture( getTerrain(), CResourceId("MyTerrain.png"), -70.0f, 200.0f );
	//getTerrain().setTexture( CResourceId( "Terrain.png" ) );

	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainH.png"), -90.0f, 180.0f );
	getTerrain().setTexture( CResourceId( "TerrainM.png" ) );
	//CMyTerrainGen::generateAdd( getTerrain() );
	//CMyTerrainGen::generate( getTerrain() );

	CGodlessEntityDecider* godlessEntityDecider = new CGodlessEntityDecider( 
		getTerrain(),
		D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, getTerrain().getAltitude( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f ) ), 
		0.01f 
	);

	int count = maxEntities/2;

	int i;

	float a = 0;
	int stoneCount = 8;
	float da = D3DX_PI * 2 / stoneCount;
	
	for( i = 0; i < stoneCount; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		//e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5 + sin( a ) * STONE_RADIUS, gcon::WORLD_Y * 0.5 + cos( a ) * STONE_RADIUS, 0.0f );
		e.mVelocity = D3DXVECTOR3( 0, 0, 0 );
		e.getOldPosition() = e.getPosition();
		//e.mDeciderCounter = rand()&15;
		e.mDeciderCounter = rand()&3 + 1;
		e.mDecider = NULL;
		e.setPicture( picStone );
		e.setSize( 10 );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = CGodlessEntity::F_GRAVITY;

		a += da;
	}

	CMyEntity& e = mPool->add();
	getEntities().add( e );
	e.getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5, gcon::WORLD_Y * 0.5, 0.0f );
	e.mVelocity = D3DXVECTOR3( 0, 0, 0 );
	e.getOldPosition() = e.getPosition();
	e.mDeciderCounter = 1;
	e.mDecider = NULL;
	e.setPicture( picDogbert );
	e.setSize( 20 );
	e.setColor( 0xFFFFFFFF );
	e.mFlags = CGodlessEntity::F_GRAVITY;

	for( i = 0; i < GODLESS_COUNT; ++i ) {
		CGodlessEntity& e = mGodlessEntityPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		//e.mDeciderCounter = rand()&15;
		e.mDeciderCounter = rand()&3 + 1;
		e.mDecider = godlessEntityDecider;
		e.setPicture( picGodless );
		e.setSize( 3.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = 0;
		//e.mFlags = CGodlessEntity::F_GRAVITY;
	}
	for( i = 0; i < BALL_COUNT; ++i ) {
		CBallEntity& e = mBallEntityPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		//e.mDeciderCounter = rand()&15;
		e.mDeciderCounter = rand()&3 + 1;
		e.mDecider = NULL;
		//e.setPicture( picBall );
		e.setPicture( *picBall[rand()%4] );
		e.setSize( 3.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = 0;
	}

	for( i = 0; i < CLOUD_COUNT; ++i ) {
		CCloudEntity& e = mCloudEntityPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 300.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		//e.mDeciderCounter = rand()&15;
		e.mDeciderCounter = rand()&3 + 1;
		e.mDecider = NULL;
		//e.setPicture( *picCloud[rand()%4] );
		e.setPicture( *pb.getResourceById( *picCloud[rand()%4] ) );
		e.mPictureId = picCloud[rand()%4];
		e.setSize( 30.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = 0;
	}

	initCamera();
}


// ------------------------------------------------------------------
//  game logic


void CMyGame::onUpdate()
{
	//if( mGameStarted ) {
	if( true ) {
		
		if( mM2Pressed ) putBall();

		// update entities
		TPool::iterator it;
		for( it = mPool->begin(); it != mPool->end();  ) {
			CMyEntity& e = *it;
			assert( e.mDeciderCounter >= 0 );
			e.update();
			if( e.mFlags & CMyEntity::F_KILLED ) {
				it = mPool->erase( it );
				getEntities().remove( e );
			} else {
				++it;
			}
		}
		TBallEntityPool::iterator it2;
		for( it2 = mBallEntityPool->begin(); it2 != mBallEntityPool->end();  ) {
			CBallEntity& e = *it2;
			assert( e.mDeciderCounter >= 0 );
			e.update();
			if( e.mFlags & CMyEntity::F_KILLED ) {
				it2 = mBallEntityPool->erase( it2 );
				getEntities().remove( e );
			} else {
				++it2;
			}
		}
		TGodlessEntityPool::iterator it1;
		for( it1 = mGodlessEntityPool->begin(); it1 != mGodlessEntityPool->end();  ) {
			CGodlessEntity& e = *it1;
			assert( e.mDeciderCounter >= 0 );
			e.update();
			if( e.mFlags & CMyEntity::F_KILLED ) {
				it1 = mGodlessEntityPool->erase( it1 );
				getEntities().remove( e );

				if( e.mOxigen > 0 ) mGodFound++;
				else mGodlessDeadCount++;
			} else {
				++it1;
			}
		}
		TCloudEntityPool::iterator ita;
		for( ita = mCloudEntityPool->begin(); ita != mCloudEntityPool->end(); ita++ ) {
			CCloudEntity& e = *ita;
			e.update();
		}
	}
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
	getBillboarder().beginBillboards();

	if( mGodFound > GODLESS_COUNT / 2 )
		getBillboarder().putScreenBill( CResourceId( "Dogbert.png" ), 0xc0ffffff, -0.5f, -0.5f, 0.5f, 0.5f );
	else if( mGodlessDeadCount > GODLESS_COUNT / 2 )
		getBillboarder().putScreenBill( CResourceId( "Dilbert.png" ), 0xc0ffffff, -0.5f, -0.5f, 0.5f, 0.5f );

	float size = 0.1f;
	float ypos = 0.85f;

	float yl = (float)( GODLESS_COUNT * 0.5 - mGodlessDeadCount ) / GODLESS_COUNT * 2.0f;
	float gl = (float)( GODLESS_COUNT * 0.5 - mGodFound ) / GODLESS_COUNT * 2.0f;

	yl *= 0.9f;
	gl *= 0.9f;

	if( yl < 0 ) yl = 0;
	if( gl < 0 ) gl = 0;

	getBillboarder().putScreenBill( CResourceId( "Dilbert.png" ), 0xd0ffffff, -yl - size, ypos, -yl, ypos + size );
	getBillboarder().putScreenBill( CResourceId( "Dogbert.png" ), 0xd0ffffff, gl, ypos, gl + size, ypos + size );

	float ddx = 0.1f;

	getBillboarder().putScreenBill( CResourceId( "lightnin.png" ), 0xd0ffffff, -ddx, ypos - ddx, ddx, ypos + size + ddx );


	/*for( TCloudEntityPool::iterator it = mCloudEntityPool->begin(); it != mCloudEntityPool->end(); it++ ) {
		getBillboarder().putWorldBill( 
			*it->mPictureId, 
			0xf0ffffff, 
			it->getPosition(),
			40, 15
		);
	}*/

	getBillboarder().endBillboards();
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
	char buf[255];

	// text
	std::string s;

	if( mGameStarted ) {
		s = "";

		s += "still looking for the GOD : ";
		sprintf( buf, "%d", GODLESS_COUNT - mGodlessDeadCount - mGodFound );
		s += buf;

		s += ".\n on the way to GOD (your score): ";
		sprintf( buf, "%d", mGodlessDeadCount );
		s += buf;

		s += ".\n found GOD (god score): ";
		sprintf( buf, "%d", mGodFound );
		s += buf;

		getTextRenderer().renderScreenText( 5, 20, s );

		if( mGodFound > GODLESS_COUNT / 2 ) {
			s = "!!!! GOD dogbert WINS !!!";

			getTextRenderer().renderScreenText( 80, 80, s, 0xffff0000 );
		} else if( mGodlessDeadCount > GODLESS_COUNT / 2 ) {
			s = "!!!! you win man. bilyv it !!!";

			getTextRenderer().renderScreenText( 80, 80, s, 0xffff0000 );
		}
	} else {
		s = "Zaidimas Dievoieska\n\n"
			"    kalno virsuje stovi dievas, kurio link traukia piligrimai. jusu manymu piligrimams nereikia pasiekti\n"
			"dievo todel jus ridenate gniuztes, kurios nunsinesa bedievius kalno slaitu. gniuzciu yra ribotas kiekis (" + getString( BALL_COUNT ) + "),\n" 
			"todel visas isnaudojus anksciau panaudotos atlaisvina piligrimus, taciau neparaskite vilties - piligrimai\n"
			"iveikiami - jei piligrimas per ilgai isbuna vandenyje (kuo ilgiau buna vandenyje tuo melynesnis tampa), jis\n"
			"atsivercia ir paraudes nukeliauja pas dieva - taskas jums. bet bukite budrus - piligrimui pasiekus kalno\n"
			"virsu jis ispazysta dieva ir palieka si pasauli tikedamas savo stabu (taskas dievui).\n\n"
			"    bedieviu yra (" + getString( GODLESS_COUNT ) + "). tas kas pirmas (tu arba dievas) surenka puse ju (" + getString( GODLESS_COUNT / 2 ) + ") laimi.\n"
			"lango apacioje esantis indikatorius pades jums orientuotis, kieno puseje yra tiesa.\n\n"
			"    valdymas: \n"
			". kairys peles mygtukas: deda viena gniuzte\n"
			". desnys peles mygtukas: deda viena gniuztes tol kol paspaustas\n\n"
			". rodykles: sukioja kamera\n"
			". s: juda i prieki\n"
			". x: juda i atgal\n"
			". z: juda i kaire\n"
			". c: juda i desne\n"
			". q: juda i virsu\n"
			". a: juda i zemyn\n"
			". space: atsuka kamera i dieva\n\n"
			"patarimai:\n"
			". geriausia valdyti: uzspausti c ir space (arba z ir space)\n"
			". nenaudoti kairio peles mygtuko - naudoti desni (sugadinsite pele :)\n\n"
			"<spauskite enter>";

		getTextRenderer().renderScreenText( 10, 20, s, 0xffffffff );
	}
}

std::string CMyGame::getString( int value ) 
{
	char buf[255];
	sprintf( buf, "%d", value );

	return buf;
}