#include "MyTerrainGen.h"

#include <math.h>
#include "../engine/Terrain.h"

float sqr( float x ) { return x * x; }

void CMyTerrainGen::generate( CTerrain& terrain )
{
	terrain.beginUpdate();

	const float mainHillZ = 150;

	for( int xi = 0; xi < terrain.CELLS_X; xi++ ) {
		float x = (float)xi / terrain.CELLS_X;
		for( int yi = 0; yi < terrain.CELLS_Y; yi++ ) {
			float y = (float)yi / terrain.CELLS_Y;

			float d = sqrt( sqr( 0.5f - x ) + sqr( 0.5f - y ) );

			float z = cos( d * 7.5 ) * mainHillZ;

			z += cos( x * 10 + y * 30 + cos( x * 10 + y * 30 ) * 30 ) * 30;
			z += cos( x * 50 + y * 90 + cos( x * 10 + y * 30 ) * 23 ) * 10;
			z += cos( x * 7 + y * 5 + sin( x * 50 + y * 90 ) * 10 ) * 10;

			terrain.setAltitude( xi, yi, z );
		}
	}

	terrain.endUpdate();
}

void CMyTerrainGen::generateAdd( CTerrain& terrain )
{
	terrain.beginUpdate();

	const float mainHillZ = 60;

	for( int xi = 0; xi < terrain.CELLS_X; xi++ ) {
		float x = (float)xi / terrain.CELLS_X;
		for( int yi = 0; yi < terrain.CELLS_Y; yi++ ) {
			float y = (float)yi / terrain.CELLS_Y;

			float d = sqrt( sqr( 0.5f - x ) + sqr( 0.5f - y ) );

			float z = cos( d * 7.5 ) * mainHillZ;
			terrain.setAltitude( xi, yi, z + terrain.getAltitudeIdx( xi, yi ) );
		}
	}

	terrain.endUpdate();
}
