#pragma warning(disable:4786)

#include "GameApp.h"
//#include "game/EngineConstants.h"

#include <string>
#include "resource/MeshBundle.h"
#include "resource/EffectBundle.h"
#include "resource/TextureBundle.h"
#include "resource/PictureBundle.h"
#include "console/Console.h"
#include "console/W32StdConsoleRenderingContext.h"

#include "BaseGame.h"

#include "EntityRenderer.h"
#include "Terrain.h"
#include "Billboarder.h"
#include "TextRenderer.h"

#include "camera/Camera.h"
#include "TerrainGen.h"

#include "../utils/Config.h"

// ENGINE CONSTANTS
#include "../game/EngineConstants.h"


CGameApp::CGameApp( CBaseGame& game, CConfig& config )
:	mGame( game ),
	mConfig( config ),
	mFrameTime( 0, 0, 0, gcon::UPDATE_FREQ )
{

/*//
	// set up engine

	CEngine::initialize();
	CEngine& engine = CEngine::getInstance();

	engine.setGame( *mGame );

	engine.setConfig( *new CConfig( "game.cfg" ) );
	CConfig& cfg = engine.getConfig();

	int maxEntities = cfg.readI( "game", "maxEntities", 10000 );
	engine.setEntities( *new CEntityRenderer( maxEntities ) );
	mObjects.addObject( engine.getEntities() );

	float terrTexX = cfg.readF( "game", "terrainTexTilesX", 4.0 );
	float terrTexY = cfg.readF( "game", "terrainTexTilesY", 4.0 );
	std::string terrTex = cfg.readS( "game", "terrainTex", "Terrain.png" );
	engine.setTerrain( *new CTerrain( CResourceId("Terrain.sha"), CResourceId(terrTex), terrTexX, terrTexY ) );
	mObjects.addObject( engine.getTerrain() );
	CTerrainGen::fillConst( engine.getTerrain(), 0.0f );

	engine.setBillboarder( *new CBillboarder() );
	mObjects.addObject( engine.getBillboarder() );

	std::string fontName = cfg.readS( "screen", "fontName", "Arial" );
	int fontSize = cfg.readI( "screen", "fontSize", 9 );
	bool fontBold = cfg.readI( "screen", "fontBold", 1 ) ? true : false;
	bool fontItalic = cfg.readI( "screen", "fontItalic", 0 ) ? true : false;
	engine.setTextRenderer( *new CTextRenderer( fontName.c_str(), fontSize, fontBold, fontItalic ) );
	mObjects.addObject( engine.getTextRenderer() );*/
	
	//
	// set up app

	std::string title = mConfig.readS( "screen", "title", "Game Jam" );
	m_strWindowTitle    = const_cast<char*>( title.c_str() );
    m_bUseDepthBuffer   = TRUE;
	m_bWindowed			= mConfig.readI( "screen", "windowed", 1 ) ? TRUE : FALSE;
	m_dwMinDepthBits	= 16;
	m_dwMinStencilBits	= 0;
	m_dwCreationWidth	= mConfig.readI( "screen", "width", 640 );
	m_dwCreationHeight	= mConfig.readI( "screen", "height", 480 );
    m_bUseDepthBuffer   = TRUE;

	mGame.setAppContext( mAppContext );
	mGame.setKeyboard( mKeyboard );
	mGame.setMouse( mMouse );
}

CGameApp::~CGameApp()
{
}

HRESULT CGameApp::OneTimeSceneInit()
{
	con::IConsoleRenderingContext* ctx = new CW32StdConsoleRenderingContext( m_hWnd );
	con::CConsole::getConsole()->setDefaultRenderingContext( *ctx );
	
    return S_OK;
}

HRESULT CGameApp::InitDeviceObjects()
{
	assert( m_pd3dDevice );

	CMeshBundle::init( *m_pd3dDevice, "mesh/" );
	CEffectBundle::init( *m_pd3dDevice, "efx/" );
	CTextureBundle::init( *m_pd3dDevice, "tex/" );
	CPictureBundle::init( *m_pd3dDevice, "tex/", 1024, 1024, 32 );
	
	mGame.onCreateDevice( m_pd3dDevice );

    return S_OK;

}

HRESULT CGameApp::RestoreDeviceObjects()
{
//	mAspect = (float)m_d3dsdBackBuffer.Width / (float)m_d3dsdBackBuffer.Height;
	mMouse.setRegion( (float)m_d3dsdBackBuffer.Width, (float)m_d3dsdBackBuffer.Height);
	mGame.onResetDevice();

	return S_OK;
}

HRESULT CGameApp::InvalidateDeviceObjects()
{
	CEffectBundle::getInstance().clear();
	mGame.onLostDevice();

	return S_OK;
}

HRESULT CGameApp::DeleteDeviceObjects()
{
	CTextureBundle::getInstance().clear();
	mGame.onResetDevice();

	return S_OK;
}

HRESULT CGameApp::Render()
{
	HRESULT hr;

	if( FAILED( hr = m_pd3dDevice->BeginScene() ) )
		return hr;

	mGame.render( mFrameTime );
	
	if( FAILED( hr = m_pd3dDevice->EndScene() ) )
		return hr;

	return S_OK;
}

HRESULT CGameApp::FrameMove()
{
/*	mGame->onProcessInput();

	CEngine::getInstance().getCamera().update( m_fElapsedTime );

	static bool gotTime = false;
	if( !gotTime ) {
		mLastUpdateTime = m_fTime - gcon::UPDATE_DT;
		gotTime = true;
	}
	float t = m_fTime - mLastUpdateTime;
	while( t >= gcon::UPDATE_DT ) {
		mGame->onUpdate();
		t -= gcon::UPDATE_DT;
	}

	mLastUpdateTime = m_fTime - t;

    return S_OK;*/

	// frame time
	int frameNr = mFrameTime.getFrameNumber();
	
	float elapsedTime = m_fElapsedTime;
	if( frameNr == 0)
		elapsedTime = gcon::UPDATE_DT;

	mFrameTime = CFrameTime( m_fTime, elapsedTime, frameNr + 1, gcon::UPDATE_FREQ );

	// app context
	mAppContext.setInfo(
		(float)m_d3dsdBackBuffer.Width / (float)m_d3dsdBackBuffer.Height,
		std::string( m_strFrameStats ),
		std::string( m_strDeviceStats ) );

	mGame.update( mFrameTime );

	return S_OK;
}


LRESULT CGameApp::MsgProc( HWND wnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	mKeyboard.onMsgProc( wnd, msg, wParam, lParam );
	mMouse.onMsgProc( wnd, msg, wParam, lParam );
	
	return CD3DApplication::MsgProc( wnd, msg, wParam, lParam );
}


/*HRESULT CMainApp::OneTimeSceneInit()
{
	con::IConsoleRenderingContext* ctx = new CW32StdConsoleRenderingContext( m_hWnd );
	con::CConsole::getConsole()->setDefaultRenderingContext( *ctx );
	
    return S_OK;
}


HRESULT CMainApp::InitDeviceObjects()
{
	// resources init
	CEffectBundle::init( *m_pd3dDevice, "efx/" );
	CTextureBundle::init( *m_pd3dDevice, "tex/" );
	CPictureBundle::init( *m_pd3dDevice, "tex/", 1024, 1024, 32 );
	
	mObjects.onCreateDevice( m_pd3dDevice );

	static bool once = true;
	if( once ) {
		// game init
		mGame->onInitialize();
		once = true;
	}

	CEngine::getInstance().setCamera( mGame->getCamera() );
	
    return S_OK;
}


HRESULT CMainApp::RestoreDeviceObjects()
{
	// camera
	CCamera& camera = CEngine::getInstance().getCamera();
	camera.setProjectionParams(
		3.1415927f * 0.4f,
		(float)m_d3dsdBackBuffer.Width / m_d3dsdBackBuffer.Height,
		5.0f,
		(gcon::WORLD_X + gcon::WORLD_Y) * 0.6f
	);
	camera.setDeviceTransforms( *m_pd3dDevice, false, true );
	
	mObjects.onResetDevice();
	
	return S_OK;
}


HRESULT CMainApp::InvalidateDeviceObjects()
{
	CEffectBundle::getInstance().clear();

	mObjects.onLostDevice();

    return S_OK;
}


HRESULT CMainApp::DeleteDeviceObjects()
{
	CTextureBundle::getInstance().clear();

	mObjects.onResetDevice();

    return S_OK;
}


// --------------------------------------------------------------------------


HRESULT CMainApp::FrameMove()
{
	mGame->onProcessInput();

	CEngine::getInstance().getCamera().update( m_fElapsedTime );

	static bool gotTime = false;
	if( !gotTime ) {
		mLastUpdateTime = m_fTime - gcon::UPDATE_DT;
		gotTime = true;
	}
	float t = m_fTime - mLastUpdateTime;
	while( t >= gcon::UPDATE_DT ) {
		mGame->onUpdate();
		t -= gcon::UPDATE_DT;
	}

	mLastUpdateTime = m_fTime - t;

    return S_OK;
}


HRESULT CMainApp::Render()
{   
    HRESULT hr;

	CEngine& engine = CEngine::getInstance();

	// alpha
	float alpha = (m_fTime - mLastUpdateTime) * gcon::UPDATE_FREQ;
	
    if( FAILED( hr = m_pd3dDevice->BeginScene() ) )
        return hr;
	
	m_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 0x00000000, 1.0f, 0 );

	// camera
	engine.getCamera().setDeviceTransforms( *m_pd3dDevice );

	// game: before
	mGame->onRenderBeforeAll();

	// render
	engine.getTerrain().render();
	engine.getEntities().render( alpha );
	engine.getBillboarder().render( alpha );

	// game: after
	mGame->onRenderAfterAll();

	// show info
	engine.getTextRenderer().renderScreenText( 4, 2, m_strFrameStats, 0x80FFFF00 );
	
	if( FAILED( hr = m_pd3dDevice->EndScene() ) )
		return hr;
		
	return S_OK;
}


LRESULT CMainApp::MsgProc( HWND wnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	CEngine& engine = CEngine::getInstance();

	switch( msg ) {
	case WM_KEYDOWN:
		if( !engine.isKeyPressed(wParam) )
			mGame->onKeyChange( wParam, true );
		engine.setKeyPressed( wParam, true );
		break;
	case WM_KEYUP:
		if( engine.isKeyPressed(wParam) )
			mGame->onKeyChange( wParam, false );
		engine.setKeyPressed( wParam, false );
		break;
	case WM_LBUTTONDOWN:
		if( !engine.isMouseLPressed() )
			mGame->onMouseLChange( true );
		engine.setMouseLPressed( true );
		break;
	case WM_LBUTTONUP:
		if( engine.isMouseLPressed() )
			mGame->onMouseLChange( false );
		engine.setMouseLPressed( false );
		break;
	case WM_RBUTTONDOWN:
		if( !engine.isMouseRPressed() )
			mGame->onMouseRChange( true );
		engine.setMouseRPressed( true );
		break;
	case WM_RBUTTONUP:
		if( engine.isMouseRPressed() )
			mGame->onMouseRChange( false );
		engine.setMouseRPressed( false );
		break;
	case WM_MOUSEMOVE:
		float mx = ((float)LOWORD(lParam) / m_d3dsdBackBuffer.Width) * 2.0f - 1.0f; 
		float my = ((float)HIWORD(lParam) / m_d3dsdBackBuffer.Height) * 2.0f - 1.0f; 
		engine.setMouseX( mx );
		engine.setMouseY( my );
		break;
	};
	
    return CD3DApplication::MsgProc( wnd, msg, wParam, lParam );
}*/
