#ifndef __MOUSE_H
#define __MOUSE_H

#include "MsgProc.h"


struct IMouseListener;
class CMouse : public IMsgProc
{
	enum { KEY_COUNT = 256 };

public:
	CMouse();

	virtual void onMsgProc( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	void setRegion( float width, float height ) { mWidth = width; mHeight = height; }
	void setListener( IMouseListener* listener ) const { mListener = listener; }

	/// Returns screen mouse X coordinate (-1 at left, 1 at right).
	float	getMouseX() const { return mMouseX; }
	/// Returns screen mouse Y coordinate (-1 at top, 1 at bottom).
	float	getMouseY() const { return mMouseY; }
	/// Returns status of left mouse button.
	bool	isMouseLPressed() const { return mMouseLPressed; }
	/// Returns status of right mouse button.
	bool	isMouseRPressed() const { return mMouseRPressed; }

private:
	float					mMouseX;
	float					mMouseY;
	bool					mMouseLPressed;
	bool					mMouseRPressed;

	float					mWidth;
	float					mHeight;

	mutable IMouseListener*	mListener;
};

struct IMouseListener
{
	virtual ~IMouseListener() = 0 {};

	virtual void onMouseLChange( bool pressed ) = 0;
	virtual void onMouseRChange( bool pressed ) = 0;
};

#endif