#include "MeshBundle.h"

#include <cassert>
#include "../../utils/Errors.h"


using namespace std;
//---------------------------------------------------------------------------
// CMeshBundle
//---------------------------------------------------------------------------
CMeshBundle::CMeshBundle( IDirect3DDevice8& device, std::string const& predir )
:	mDevice( device ),
	mPreDir( predir )
{
}

CMeshBundle::~CMeshBundle()
{
	// HACK: in order to clear resources
	clear();
	
	CONSOLE.write( "mesh bundle destroyed" );
}

ID3DXMesh* CMeshBundle::loadResourceById( CResourceId const& id )
{
	ID3DXBuffer* adjancency = NULL;
	ID3DXBuffer* material = NULL;
	DWORD materialsCount;
	ID3DXMesh* newMesh = NULL;

	HRESULT hres = D3DXLoadMeshFromX(
		(char*)(mPreDir + id.getUniqueName()).c_str(),
		D3DXMESH_MANAGED, //D3DXMESH_VB_MANAGED,
		&mDevice,
		&adjancency,
		&material,
		&materialsCount,
		&newMesh );
	if( !SUCCEEDED( hres ) )
	{
		THROW_DXERROR( hres, "failed to load mesh '" + id.getUniqueName() + "'" );
	}
	assert( newMesh );

	CONSOLE.write( "mesh loaded '" + id.getUniqueName() + "'" );
	

	if( adjancency )
		// DEBUG
		ULONG i = adjancency->Release();

	if( material )
		// DEBUG
		ULONG i = material->Release();

	
	return newMesh;
}

void CMeshBundle::touchResource( ID3DXMesh& resource )
{
	resource.AddRef();
}

void CMeshBundle::clearResource( ID3DXMesh& resource )
{
	// DEBUG
	ULONG i = resource.Release();
}