#include "BombEntity.h"

#include "MyGame.h"
#include "EngineConstants.h"
#include "../engine/Terrain.h"
#include "../utils/Random.h"

const float CBombEntity::GRAVITY = 7.0f;

CBombEntity::CBombEntity()
:	mExplosion( 255 ), mYours( true )
{
}

void CBombEntity::update()
{
	CSector& sLast = CMyGame::getInstance().mGrid->getSectorByPosition( getOldPosition().x, getOldPosition().y );
    if( sLast.mBomb == this ) sLast.mBomb = NULL;

	setColor( 0xff000000 + (( 255 - mExplosion ) << 16 ) + (( 255 - mExplosion ) << 8 ) + ( 255 - mExplosion ) );
	//setColor( 0xffff0000 + (( 255 - mExplosion ) << 8 ) + ( 255 - mExplosion ) );
	//setColor( 0x00000000 + (( 255 - mExplosion ) << 8 ) + ( 255 - mExplosion ) );
	if( mExplosion > 0 && mExplosion < 255 ) mExplosion++;

	if( !isExploded() ) {
		CSector& sNow = CMyGame::getInstance().mGrid->getSectorByPosition( getPosition().x, getPosition().y );
		sNow.mBomb = this;
	} 

	D3DXVECTOR3 pos = getOldPosition() = getPosition();

	const float inf = 0.3f;
	
	mVelocity = ( mVelocity + D3DXVECTOR3( 0, 0, GRAVITY * ( mYours ? -1 : 1 ) ) * inf ) * 0.9f;

	pos += mVelocity;

	bool expld = false;

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;

		expld = true;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
		
		expld = true;
	}

	if( pos.z > CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) - getSize() ) {
		pos.z = CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) - getSize();
		if( mYours ) mVelocity.z = -mVelocity.z;

		expld = true;
	}

	if( pos.z < CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize() ) {
		pos.z = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();
		if( !mYours ) mVelocity.z = -mVelocity.z;

		expld = true;
	}

	if( expld ) {
		explode();
		explodeFire( pos );
	}

	getPosition() = pos;
}

void CBombEntity::reset( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, bool yours )
{
	mYours = yours;

	assert( mBombPic );
	setPicture( *mBombPic );
	getOldPosition() = getPosition() = pos;
	mVelocity = velocity;
	//setSize( 7 );
	mExplodeSizeSq = getSize() * getSize();

	mExplosion = 0;

	setColor( 0xffffffff );
}

void CBombEntity::explode()
{
	if( !isExploded() ) {
		assert( mExplosionPic );
		setPicture( *mExplosionPic );
		//setSize( 10 );
		if( mExplosion == 0 ) { 
			explodeFire( getPosition() );
			mExplodeSizeSq *= 81;
			mExplosion++;
		}
	}
}

void CBombEntity::explodeFire( const D3DXVECTOR3& pos ) 
{
	if( getSize() < 0.5f || isExploded() ) return;

	CTerrain* terrain;

	if( mYours ) terrain = CMyGame::getInstance().mTerrainTop;
	else terrain = &CMyGame::getInstance().getTerrain();

	float d = 5;

	D3DXVECTOR3 v1( pos.x - d, pos.y, 0 );
	if( v1.x < 0 ) v1.x = 0;
	D3DXVECTOR3 v2( pos.x, pos.y - d, 0 );
	if( v2.y < 0 ) v2.y = 0;

	v1 = D3DXVECTOR3( d, 0,
		terrain->getAltitude( pos.x, pos.y ) -
		terrain->getAltitude( v1.x, v1.y ) );

	v2 = D3DXVECTOR3( 0, d,
		terrain->getAltitude( pos.x, pos.y ) -
		terrain->getAltitude( v2.x, v2.y ) );

	D3DXVECTOR3 normal;

	//if( pos.z > 0 ) D3DXVec3Cross( &normal, &v1, &v2 );
	//else D3DXVec3Cross( &normal, &v2, &v1 );

	D3DXVec3Cross( &normal, &v2, &v1 );

	if( pos.z * normal.z > 0 ) normal = -normal;

	D3DXVec3Normalize( &normal, &normal );

	D3DXVECTOR3 front( 1, 0, 0 ), up;

	D3DXVec3Cross( &up, &normal, &front );
	D3DXVec3Cross( &front, &normal, &up );

	D3DXVec3Normalize( &front, &front );
	D3DXVec3Normalize( &up, &up );

	int fireCount = rand()&63;
	const float velocityRandLim = 0.7f;
	const float speed = 15;

	float gravity = ( mYours ? -GRAVITY : GRAVITY ) * 0.3f;

	while( fireCount > 0 ) {
		CFireBillboard* f = CMyGame::getInstance().nextFire();
		
		f->reset( 
			pos + D3DXVECTOR3( random::randfs( 5.0f ), random::randfs( 5.0f ), random::randfs( 5.0f ) ),
			( normal * 1.5f + front * random::randfs( velocityRandLim ) + up * random::randfs( velocityRandLim ) ) * speed,
			gravity,
			rand()&63,
			3,
			0xffffffff
		);

		fireCount--;
	}
}

int CBombEntity::fire( const D3DXVECTOR3& pos, const D3DXVECTOR3& direction, const D3DXVECTOR3& up, bool yours, CItemEntity::eType item )
{
	int bombCount = 1;
	if( item == CItemEntity::eType::FIRE_3 ) bombCount = 3;
	else if( item == CItemEntity::eType::PIG ) bombCount = 0;

	float size = 5;
	if( item == CItemEntity::eType::FIRE_BIG ) size = 15;
	
	
	
	float dir = 0.6f;
	D3DXVECTOR3 attackDir = direction * dir + up * ( 1.0f - dir );

	D3DXVECTOR3 right;
	D3DXVec3Cross( &right, &attackDir, &up );

	
	for( int i = 0; i < bombCount; i++ ) {
		
		float limit = 0;
		if( i > 0 ) limit = 0.3f;

		CBombEntity* b = CMyGame::getInstance().nextBomb();
		b->setSize( size );
		b->reset( 
			pos, 
			(	attackDir + 
				right * random::randfs( limit ) +
				up * random::randfs( limit ) 
			) * 90, 
			yours 
		);		
		b->mExplodeSizeSq = b->getSize() * b->getSize();
	}

	return bombCount;
}

