#ifndef __BOMB_ENTITY_H
#define __BOMB_ENTITY_H

#include "../engine/Entity.h"
#include "ItemEntity.h"

class CBombEntity : public CEntity {
public:
	CBombEntity();
	void update();

	void explode();
	bool isExploded() { return mExplosion > 20; }

	D3DXVECTOR3 getNormal( const D3DXVECTOR3& pos, bool top );
	void explodeFire( const D3DXVECTOR3& pos );

	static int fire( const D3DXVECTOR3& pos, const D3DXVECTOR3& direction, const D3DXVECTOR3& up, bool yours, CItemEntity::eType item );

	float getExplodeSizeSq() { return mExplodeSizeSq; }

public:
	static const float GRAVITY;

	D3DXVECTOR3		mVelocity;
	
	int				mExplosion;
	const CPicture* mBombPic;
	const CPicture* mExplosionPic;

	bool mYours;

private:
	float			mExplodeSizeSq;
	void reset( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, bool yours );
};


#endif
