#include "DummyEntity.h"

#include "MyGame.h"
#include "ShootBilboard.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/Terrain.h"
#include "../utils/Random.h"

const float CDummyEntity::GRAVITY = 8;

CDummyEntity::CDummyEntity( const CPicture& yourPicture, const CPicture& oponentPicture, bool yours )
:	mYours( yours ), mYourPicture( &yourPicture ), mOponentPicture( &oponentPicture )
{
}

void CDummyEntity::update()
{
	getOldPosition() = getPosition();

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	correctPos( pos );

	float bottom = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();
	float top = CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) - getSize();

	if( mYours ) {
		if( pos.z > bottom ) pos.z -= GRAVITY;
		if( pos.z < bottom ) pos.z = bottom;

		if( pos.z > top ) mVelocity += D3DXVECTOR3( random::randfs(3.0f), random::randfs(3.0f), 0.0f );
		else;
	} else {
		if( pos.z < top ) pos.z += GRAVITY;
		if( pos.z > top ) pos.z = top;

		if( pos.z < bottom ) mVelocity += D3DXVECTOR3( random::randfs(3.0f), random::randfs(3.0f), 0.0f );
		else;
	}

	if( CMyGame::getInstance().mNetClient ) {
		// colision with bombs
		const CSector& s = CMyGame::getInstance().mGrid->getSectorByPosition( getPosition().x, getPosition().y );
					
		if( s.mBomb && !s.mBomb->isExploded() && 
			( ( mYours && !s.mBomb->mYours ) || ( !mYours && s.mBomb->mYours ) ) ) 
		{
			D3DXVECTOR3 d = getPosition() - s.mBomb->getPosition();
			if( D3DXVec3LengthSq( &d ) < s.mBomb->getExplodeSizeSq() ) {
				s.mBomb->explode();
		
				if( !s.mBomb->mYours ) {                                             
					if( CMyGame::getInstance().mOponent->mOwned > 0 ) {
						setYours( false );
						CMyGame::getInstance().mOponent->useOwned();

						CShootBillboard::addShoots( s.mBomb, this );
					}
				} else {
					setYours( true );
  					CMyGame::getInstance().mOwnedOponent++;
					CMyGame::getInstance().mYoursCount++;

					CShootBillboard::addShoots( s.mBomb, this );
				}
			}
		}
	}
	
	getPosition() = pos;
}

void CDummyEntity::correctPos( D3DXVECTOR3& pos )
{
	float bound = 30;
	if( pos.x >= gcon::WORLD_X - bound || pos.x < bound ) { 
		pos.x = getOldPosition().x;
		mVelocity.x = -mVelocity.x;
	}
	if( pos.y >= gcon::WORLD_Y - bound || pos.y < bound ) {
		pos.y = getOldPosition().y;
		mVelocity.y = -mVelocity.y;
	}
}

void CDummyEntity::setYours( bool b ) 
{ 
	assert( mYourPicture && mOponentPicture );

	mYours = b; 
	if( mYours ) setPicture( *mYourPicture );
	else setPicture( *mOponentPicture );
}

void CDummyEntity::switchPictures()
{
	const CPicture* p = mYourPicture;
	mYourPicture = mOponentPicture;
	mOponentPicture = p;

	setYours( mYours );
}