#include "FireBilboard.h"

//#include "MyGame.h"
#include "EngineConstants.h"
//#include "../engine/Terrain.h"

//const float CBombEntity::GRAVITY = 7.0f;

CFireBillboard::CFireBillboard()
:	mPictureId( CResourceId( "" ) ), mLifeTime( -1 )
{
}

CFireBillboard::CFireBillboard( CResourceId pic )
:	mPictureId( pic ), mLifeTime( -1 )
{
}

void CFireBillboard::update()
{
	if( isAlive() ) {
		const float inf = 0.3f;
	
		mVelocity = ( mVelocity + D3DXVECTOR3( 0, 0, mGravity ) * inf ) * 0.9f;

		mPosition += mVelocity;

		/*if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
			mVelocity.x = -mVelocity.x;
			pos.x = getOldPosition().x;
		}
		if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
			mVelocity.y = -mVelocity.y;
			pos.y = getOldPosition().y;
		}*/

		mColor = mColor & 0x00ffffff + (((int)( ((float)mLifeTime)/mLifeTimeAll * 255.0f )) << 24 );

		mLifeTime--;
	}
}

void CFireBillboard::reset( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, float gravity, int lifeTime, float size, D3DCOLOR color )
{
	mPosition = pos;
	mVelocity = velocity;
	mGravity = gravity;
	mLifeTimeAll = mLifeTime = lifeTime;
	mSize = size;
	mColor = color;
}